#!/usr/bin/perl


package pipeline;



use FindBin;                 # locate this script
use lib "$FindBin::Bin/metaRNAmodules_mapping/";  # use the parent directory
use strict;
use warnings;
use splitInstance;
use getRfamStructureTables;
use pumo2fr3d;
use Data::Dumper;





## Package tostart the metaRNAmodules pipeline fir a putative module instance
## Input: putative motif instance (format:: Instance: 3DKN F   11 F   25 / F   15 F   23)
## Input: hashReference with path and name details
## written: 09/03/2012 - corinna






sub startPipeline {

	
	my ($infoHash, $instance, $class) = @_;
	
	#################
	## print information
	print STDOUT "\#\# Start pipeline....\n";
	
	###################################################
	## split module instance for details and store details in a hash
	my $moHashRef;
	$moHashRef = splitInstance::splitInstance($instance);
	$$moHashRef{"class"} = $class;
	print "\#\# Class: $class\n";
	## compare motif chains to make sure that only 1 chain is involved, first filter
	my $chainFlag = "F";
	$chainFlag = compareChains($moHashRef);
	
	if($chainFlag eq "T"){ ## only proceed if motif has max 1 chain
		
		#################
		## print information
		print STDOUT "\#\# First filter: ";
		print STDOUT "chain comparison okay\n";
		getRfamStructureTables::getRfamStructureLinks($moHashRef, $infoHash);
	}
	else{ $moHashRef = (); print "Module has different chain IDs\n\n"; }
}





sub compareChains {

	my $moHashRef = shift;
	my $chainFlag = "F";
	if(($$moHashRef{"chainOuter1"} eq $$moHashRef{"chainInner1"}) && ($$moHashRef{"chainInner2"} eq $$moHashRef{"chainOuter2"}) && ($$moHashRef{"chainOuter1"} eq $$moHashRef{"chainOuter2"})){
		$chainFlag = "T";
	}
	return($chainFlag);
}





1;

