#!/usr/bin/perl


package printFiles;



use FindBin;
use lib "$FindBin::Bin/lib/";
use utils;
use strict;
use warnings;
use Data::Dumper;



## Package to print all sort of files
## Return: nothing
## written: 07/03/2012 - corinna






sub printFasta {

	my $org = shift;
	my $ungapSeq = shift;
	my $mofi = shift;
	my $start = shift;
	my $stop = shift;
	my $tmpFasta = "/tmp/".$mofi."/".$org."_".$start."_".$stop.".fas";
	#print "\n\n".$tmpFasta."   write FASTA file\n\n";
	unless(-e $tmpFasta){
		open(FA, ">$tmpFasta") or die "\nCan't open $tmpFasta in printFiles\n\n";
		print FA ">".$org."\n";
		print FA $ungapSeq."\n";
		close(FA);
		#print "Fasta written\n";
	}
}





sub getOutputDir {

	my ($class, $ug11, $ug12, $ug21, $ug22, $pdb, $fam, $mainOutDir) = @_;
	my $let = substr($pdb, 1, 1);
	if(! -d $mainOutDir){ `mkdir $mainOutDir`; }
	$mainOutDir .= $let."/";
	if(! -d $mainOutDir){ `mkdir $mainOutDir`; }
	$mainOutDir .= $fam."_".$class."_".$pdb."_".$ug11."_".$ug12."_".$ug21."_".$ug22."/";
	if(! -d $mainOutDir){ `mkdir $mainOutDir`; }
	return($mainOutDir);
}








sub printModifiedAlignment {

	my ($modifiedAlignmentHashRef, $seqNameArrRef, $headArrRef, $tmp, $fam, $modAliName) = @_;
	
	print STDOUT "\#\# Print first (tmp) modified alignment\n";
	
	my $random = int(rand(70007000));
	my $nameLen = 0;
	foreach my $name(@$seqNameArrRef){
		if(length($name) > $nameLen){ $nameLen = length($name); }
	}
	#my $outD = utils::getTemporaryDirectory($tmp);
	my $out = $tmp.$fam.$modAliName;
	
	open(OU, ">$out") or die "\nCan't open $out in printFiles\n\n";
	print OU "\# STOCKHOLM 1.0\n\n";
	foreach my $head(@$headArrRef){
		print OU $head."\n";
	}
	print OU "\n\n";
	foreach my $name(@$seqNameArrRef){
		if(exists($$modifiedAlignmentHashRef{$name})){
			my $seq = uc($$modifiedAlignmentHashRef{$name});
			while(length($name) < ($nameLen+10)){ $name .= " "; }
			print OU $name.$seq."\n";
		}	
	}
	print OU "//\n";
	close(OU);
	return($out);
}





sub printMoRep {

	my ($moHashRef, $strucTabRef, $outDir,$uniqueModuleNameSuffix) = @_;
	
	#################
	## print information
	print STDOUT "\#\# Print module file\n";
	
	my $pumos = $$moHashRef{"motifSeqs"};
	my ($mo1Seq, $mo2Seq) = split(/\&/, $pumos);
	my $dot = $$moHashRef{"dotBracket"};
	my $pdb = $$moHashRef{"pdb"};
	my $basepairsArrRef = $$moHashRef{"basepairs"};
	my @bpArr = @$basepairsArrRef;
	my @revBpArr = reverse(@bpArr);
	my $class = $$moHashRef{"class"};
	my $fam = $$strucTabRef{"fam"};
	my $org = $$strucTabRef{"org"};
	my $rfamEmblSeqPosStart = $$strucTabRef{"rfamEmblSeqPosStart"};
	my $rfamEmblSeqPosStop = $$strucTabRef{"rfamEmblSeqPosStop"};
	my $ug11 = $$moHashRef{"ungapSeedAliPumo1RfamStart"};
	my $ug12 = $$moHashRef{"ungapSeedAliPumo1RfamStop"};
	my $ug21 = $$moHashRef{"ungapSeedAliPumo2RfamStart"};
	my $ug22 = $$moHashRef{"ungapSeedAliPumo2RfamStop"};
	my $g11 = $$moHashRef{"gapSeedAliPumo1RfamStart"};
	my $g12 = $$moHashRef{"gapSeedAliPumo1RfamStop"};
	my $g21 = $$moHashRef{"gapSeedAliPumo2RfamStart"};
	my $g22 = $$moHashRef{"gapSeedAliPumo2RfamStop"};

	my $nmg11 = $$moHashRef{"gapSeedAliPumo1RfamStart_notModified"};
	my $nmg12 = $$moHashRef{"gapSeedAliPumo1RfamStop_notModified"};
	my $nmg21 = $$moHashRef{"gapSeedAliPumo2RfamStart_notModified"};
	my $nmg22 = $$moHashRef{"gapSeedAliPumo2RfamStop_notModified"};
	
	my $moRep = $$moHashRef{"moRep"};
	my $computedMotifs = $$moHashRef{"computedMotifs"};
	my $bptypesArrRef = $$moHashRef{"basetypes"};
	my @bptypesArr = @$bptypesArrRef;
	my @revBptypesArrRef = reverse(@bptypesArr);
	
	my $moout = $outDir.$fam."_".$class."_".$pdb."_".$ug11."_".$ug12."_".$ug21."_".$ug22.$uniqueModuleNameSuffix;
	my $posInner1 = $$moHashRef{"posInner1"};
	my $posInner2 = $$moHashRef{"posInner2"};
	my $posOuter1 = $$moHashRef{"posOuter1"};
	my $posOuter2 = $$moHashRef{"posOuter2"};
	my $len1 = length($mo1Seq);
	my $do1 = substr($dot, 0, $len1);
	my $do2 = substr($dot,($len1+1));
	open(MO, ">$moout") or die "\nCan't open $moout in printFiles\n\n";
	print MO "******************************\n\n";
	print MO "PDB: ".$pdb."\n";
	print MO "RFAM: ".$fam."\n";
	print MO "CLASS: ".$class."\n";
	print MO "ORG: ".$org."/".$rfamEmblSeqPosStart."-".$rfamEmblSeqPosStop."\n";
	print MO "Ungapped seed alignment position: ".$ug11."-".$ug12."/".$ug21."-".$ug22."\n";
	print MO "Gapped seed alignment position: ".$g11."-".$g12."/".$g21."-".$g22."\n";
	print MO "PDB position: ".$posOuter1."-".$posInner1."/".$posInner2."-".$posOuter2."\n";
	print MO "Gapped modified seed alignment position: ".$nmg11."-".$nmg12."/".$nmg21."-".$nmg22."\n";
	print MO "Putative Module: ".$mo1Seq."&".$mo2Seq."\n";
	print MO "Dot-Bracket notation: ".$do1."&".$do2."\n";
	#print MO "Module representation: ".$moRep."\n";	
	my $c = 0;
	foreach my $bp(@revBpArr){
		my ($fi, $se) = split(/[\s\t]+/, $bp);
		my $newSe = $se -1;
		my $type = $revBptypesArrRef[$c];
		$type =~ s/\,//g;
		my $bpcount = $c + 1;
		print MO "BP ".$bpcount.": ".$newSe."\t".$fi."\t".$type."\n";
		$c++;
	}
	print MO "\n********************************\n\n";
	close(MO);
	if(! -e $moout.".gz"){
		`gzip $moout`;
	}
	return($moout.".gz");
}






sub printMapArr {

	my $mappingArrRef = shift;
	#print scalar @$mappingArrRef."   \n";
	my @strArr = ("RfamEmbl", "RfamSeq", "PDBEmbl", "PDBres", "PDBRfam", "PuMoSeqPos", "PuMoPDBres", "PMungapSeed");
	foreach my $st(@strArr){
		while(length($st) < 12){
			$st .= " ";
		}
	}
	print "\n\n";
	foreach my $s(@strArr){
		print $s."";
	}
	print "\n\n";
	my @noArr = (1,2,3,4,5,6,7,8);
	#foreach my $no(@noArr){
	#	print $no."\t";
	#}
	for(my $z = 0; $z < scalar @noArr-7; $z+=8){
			print $noArr[$z]."\t\t";
			print $noArr[$z+1]."\t";
			print $noArr[$z+2]."\t\t";
			print $noArr[$z+3]."\t";
			print $noArr[$z+4]."\t\t";
			print $noArr[$z+5]."\t\t";
			print $noArr[$z+6]."\t";
			print $noArr[$z+7]."\n";
	}
	print "------------------------------------------------------------------------------------------------------------------------------------------\n\n";
	
	for(my $x = 0; $x < scalar @$mappingArrRef - 7; $x += 8){
		my $arr1 = $$mappingArrRef[$x];
		my $arr2 = $$mappingArrRef[$x+1];
		my $arr3 = $$mappingArrRef[$x+2];
		my $arr4 = $$mappingArrRef[$x+3];
		my $arr5 = $$mappingArrRef[$x+4];
		my $arr6 = $$mappingArrRef[$x+5];
		my $arr7 = $$mappingArrRef[$x+6];
		my $arr8 = $$mappingArrRef[$x+7];
		
		
		for(my $z = 0; $z < scalar @$arr1; $z++){
			print $$arr1[$z]."\t\t";
			print $$arr2[$z]."\t";
			print $$arr3[$z]."\t\t";
			print $$arr4[$z]."\t";
			print $$arr5[$z]."\t\t";
			print $$arr6[$z]."\t\t";
			print $$arr7[$z]."\t";
			print $$arr8[$z]."\n";
		}
	}
	print "\n*****************************************************************************************************************\n\n";

}




1;
