#!/usr/bin/perl


package pumo;



use strict;
use warnings;
use Data::Dumper;




## Package to return for a given putative motif details from the corresponding putative motif file
## like motif sequences, dot-bracket notation
## Input: hash ref with putative motif details
## Return: array with motif sequences, dot-bracket notation
## written: 09/03/2012 - corinna






sub getPumoDetails {

	my ($motHashRef, $seqArrRef, $classFiZip) = @_;
	
	print STDOUT "\#\# Get module details from FR3D\n";
	
	my ($moPart1Seq, $moPart2Seq, $dotBracket) = getPumoDetailsFromFr3d($motHashRef, $seqArrRef, $classFiZip);
	return($moPart1Seq, $moPart2Seq, $dotBracket);
}





sub getPumoDetailsFromFr3d {
	
	my ($motHashRef, $seqArrRef, $classFiZip) = @_;
	my $moPart1Seq = "";
	my $moPart2Seq = "";
	my $dotBracket = "";
	
	if(scalar @$seqArrRef > 0){
		
		my $flag = "F";
		my $fillHashFlag = "F";
		my $p = $$motHashRef{"pdb"};
		my $b = $$motHashRef{"posOuter1"};
		my $d = $$motHashRef{"posOuter2"};
		my $e = $$motHashRef{"chainInner1"};
		my $f = $$motHashRef{"posInner1"};
		my $g = $$motHashRef{"chainInner2"};
		my $h = $$motHashRef{"posInner2"};
		my $chain1Seq = "";
		
		my $moPart1ChainO = $$motHashRef{"chainOuter1"};
		my $moPart1ChainI = $$motHashRef{"chainInner1"};
		
		if(uc($moPart1ChainO) eq uc($moPart1ChainI)){
			for(my $x = 0; $x < scalar @$seqArrRef-1; $x += 2){
				if($$seqArrRef[$x] =~ /fredSeq\_$moPart1ChainO/){
					$chain1Seq = $$seqArrRef[$x+1];
				}
			}
			$moPart1Seq = substr($chain1Seq, ($$motHashRef{"posOuter1"}-1), (($$motHashRef{"posInner1"}-$$motHashRef{"posOuter1"})+1));
		}
		
		my $chain2Seq = "";
		my $moPart2ChainO = $$motHashRef{"chainOuter2"};
		my $moPart2ChainI = $$motHashRef{"chainInner2"};
		
		if(uc($moPart2ChainO) eq uc($moPart2ChainI)){
			for(my $y = 0; $y < scalar @$seqArrRef-1; $y += 2){
				if($$seqArrRef[$y] =~ /fredSeq\_$moPart2ChainO/){
					$chain2Seq = $$seqArrRef[$y+1];
				}
			}
			$moPart2Seq = substr($chain2Seq, ($$motHashRef{"posInner2"}-1),(($$motHashRef{"posOuter2"}-$$motHashRef{"posInner2"})+1));
		}
		
		my $x = 1;
		local $/ = "Instances of motif:";
		my $classFiUz = $classFiZip;
		$classFiUz =~ s/\.gz//g;
		if(-e $classFiZip && ! -e $classFiUz){ `gzip -9 $classFiZip`; }
		
		if(-e $classFiUz){
			open(MO,"<".$classFiUz) or die "\nCan't open $classFiUz  in pumo\n\n";
			while(<MO>){
						
				next unless($_ =~ /$$motHashRef{"pdb"}/g);
				chomp($_);		
				my @instArr = split(/\n/,$_);
				my @correctMotif = grep(/Instance\:[\t\s]+$p[\t\s]+$moPart1ChainO[\t\s]+$b[\t\s]+$moPart2ChainO[\t\s]+$d[\t\s]+\/[\t\s]+$e[\t\s]+$f[\t\s]+$g[\t\s]+$h/gi, @instArr);
				
				next unless(scalar @correctMotif > 0);
				my @basepairArr = ();
				my @baseTypeArr = ();
				foreach (@instArr){
					
					chomp($_);
					if($_ =~ /^\d+/){
						if($fillHashFlag eq "T"){
							last;
						}
						$flag = "F";
						$x = 1;
					}
					elsif($_ =~ /^([ACGUT\&]+)/){
						my ($seqChain1, $seqChain2) = split(/\&/,$1);
						if(($seqChain1 eq $moPart1Seq) && ($seqChain2 eq $moPart2Seq)){
							$flag = "T";
						}
					}
					elsif($_ =~ /^([\(\.\)\<\>\{\}3]+)/){
						if($flag eq "T"){
							$dotBracket = $1;
						}	
					}
				     elsif($_ =~ /^[\s\t]+(\d+[\s\t]+\d+)[\s\t]+[\-\w]+[\s\t]+(\([ctWSHbif\,\?]+\))   \[[\"\d\w\,\.]*\]/i){
						if($flag eq "T"){
							
							push(@basepairArr, $1);
							push(@baseTypeArr, $2);
							my $intact  = $2;
							$intact =~ s/\,//g;
							$intact =~ s/\(//g;
							$intact =~ s/\)//g;
							if($intact eq "???"){ $intact = "bif"; }
							
							my $interactHashRef = $$motHashRef{"interactHash"};
							
							if(exists $$interactHashRef{"base".$x."lw-class"}){
								if(uc($$interactHashRef{"base".$x."lw-class"}) eq uc($intact)){
									$fillHashFlag = "T";
									$x += 2;
								}
								else{
									$fillHashFlag = "F";
								}
							}
							else{ $x = 1; }
						}
					}
				}
				if($fillHashFlag eq "T"){
					$$motHashRef{"dotBracket"} = $dotBracket;
					$$motHashRef{"basepairs"} = \@basepairArr;
					$$motHashRef{"basetypes"} = \@baseTypeArr;
					last;
				}
			}
			close(MO);
			if(exists($$motHashRef{"dotBracket"})){
				##do nothing
			}
			else{
				$$motHashRef{"dotBracket"} = "";
			}
		}
		return($moPart1Seq, $moPart2Seq, $dotBracket);
	}
}



1;
