#!/usr/bin/perl


package pumo2fr3d;



use FindBin;
use lib "$FindBin::Bin/metaRNAmodules_mapping/";
use lib "$FindBin::Bin/lib/";
use pumo;
use utils;
use strict;
use warnings;
use filter;
use Data::Dumper;




## Package to return for a given putative module details from the corresponding FR3D file like PDB residues, LW-classes
## Input: hash ref with motif details
## Return: hash ref extended by interaction array for module and Fr3d sequence
## written: 09/03/2012 - corinna




sub mapPumo2Fr3d {
	
	my ($moHashRef, $infoHash, $strucTabEntryHashRef) = @_;
	my $fr3dFiName = $$infoHash{"fr3dFiName"};
	my $fr3dPath = $$infoHash{"fr3dpath"};
	my $pdb = $$moHashRef{"pdb"};
	my $classFiZip = $$infoHash{"tmpClassFile"};
	my $tmp = $$infoHash{"instTmpDir"};
	
	####################
	## print information
	print STDOUT "\#\# Map putative module to FR3D\n";
	
	my @seqArr = ();
	
	## get some details from the FR3D file like Leontis-Westhof class, PDB residues
	getBasepairInfo($fr3dFiName, $fr3dPath, $pdb, $moHashRef, $tmp);
	
	my $intHashRef = $$moHashRef{"interactHash"};
	my $mo1StartRes = $$intHashRef{"base1PDBres"};
	my $mo2StopRes = $$intHashRef{"base2PDBres"};
	my $pdbResStart = $$strucTabEntryHashRef{"pdbResStart"};
	my $pdbResStop = $$strucTabEntryHashRef{"pdbResStop"};
	
	
	## 3. filter: module residues that are not inside the PDB residues
	if(($mo1StartRes >= $pdbResStart) && ($mo2StopRes <= $pdbResStop)){
		my @fredseqs = grep { $_ =~ /fredSeq\_/} keys %$moHashRef;
		foreach my $fredseq(@fredseqs){
			push(@seqArr, $fredseq);
			push(@seqArr, $$moHashRef{$fredseq});
		}
		
		my ($moPart1Seq, $moPart2Seq, $dotBracket) = pumo::getPumoDetails($moHashRef, \@seqArr, $classFiZip);
		$$moHashRef{"motifSeqs"} = $moPart1Seq."&".$moPart2Seq;
		$$moHashRef{"dotBracket"} = $dotBracket;
		
		filter::filterMotifs($moHashRef, $infoHash, $strucTabEntryHashRef);
	}
	else{
		print STDOUT "EMBL positions do not overlap\n\n";
	}	
}




sub getBasepairInfo {

	my ($fr3dFiName, $fr3dPath, $pdb, $moHashRef, $tmpDir) = @_;
	if(scalar keys %$moHashRef > 0){
		
		my $fredFi = $fr3dPath.$pdb.$fr3dFiName;
		my $seq = "";
		my $interact = "";
		my $n1Number = 0;
		my $chain1 = "";
		my $chain2 = "";
		my $n2Number = 0;
		my $pdbResOuter1 = 0;
		my $pdbResOuter2 = 0;
		my %interactHash = ();
		my $fl = "T";
		my $bpCount = 0;
		
		my $fredFiUz = $pdb.$fr3dFiName;
		$fredFiUz =~ s/\.gz//g;
		if(-e $fredFi && ! -e $tmpDir.$fredFiUz){
			`cp $fredFi $tmpDir`;
			`gzip -d $tmpDir$pdb$fr3dFiName`;
		}
		open(FR, "< $tmpDir$fredFiUz") or die "\nCan't open $tmpDir$fredFiUz in pumo2fred\n\n";
		while(<FR>){
				
			chomp($_);
			if($_ =~ /^\#[\s\t]+([A-Za-z0-9]+)[\s\t]+([acgutnACGUTN]+).*/){
				my $fredChain = uc($1);
				
				if(($fredChain eq $$moHashRef{"chainOuter1"}) || ($fredChain eq $$moHashRef{"chainOuter2"}) || ($fredChain eq $$moHashRef{"chainInner1"}) || ($fredChain eq $$moHashRef{"chainInner2"})){
					$$moHashRef{"fredSeq_".$fredChain} = $2;
				}
			}

			elsif($_ =~ /^$$moHashRef{"pdb"}\s+([ctWHSbif]+)\t+\w{1}\t+(\d+)\t+([\w\d]+)\t+(\d+)\t+\w{1}\t+(\d+)\t+([\d\w]+)\t+(\d+)/i){
				
				$interact = $1;
				$pdbResOuter1 = $2;
				$chain1 = $3;
				$n1Number = $4;
				$pdbResOuter2 = $5;
				$chain2 = $6;
				$n2Number = $7;
				#### class 787 has a problem in the fr3dfile (154B: number not correct)
				#### 3D5D    cWW     G       1526    A       1545    C       154B    A       1566
				#### 
				if($fl eq "T"){
					
					if((uc($chain1) eq $$moHashRef{"chainOuter1"}) && ($n1Number == $$moHashRef{"posOuter1"}) && (uc($chain2) eq $$moHashRef{"chainOuter2"}) && ($n2Number == $$moHashRef{"posOuter2"}) && (uc($interact) eq "CWW")){
						
						$fl = "F";
						$bpCount++;
						$interactHash{"base".$bpCount."SeqPos"} = $n1Number;
						$interactHash{"base".$bpCount."lw-class"} = $interact;
						$interactHash{"base".$bpCount."PDBres"} = $pdbResOuter1;
						$interactHash{"base".$bpCount."chain"} = $chain1;
						$bpCount++;
						$interactHash{"base".$bpCount."SeqPos"} = $n2Number;
						$interactHash{"base".$bpCount."PDBres"} = $pdbResOuter2;
						$interactHash{"base".$bpCount."chain"} = $chain2;
						$interactHash{"base".$bpCount."lw-class"} = $interact;
					}
				}
				elsif($fl eq "F"){
					if((uc($chain1) eq $$moHashRef{"chainInner1"}) && (($n1Number >= $$moHashRef{"posOuter1"}) && ($n1Number <= $$moHashRef{"posInner1"})) && (uc($chain2) eq $$moHashRef{"chainInner2"}) && ($n2Number <= $$moHashRef{"posOuter2"}) && ($n2Number >= $$moHashRef{"posInner2"})){
						#print $_."   $bpCount\n";	
						$bpCount++;
						$interactHash{"base".$bpCount."SeqPos"} = $n1Number;
						$interactHash{"base".$bpCount."lw-class"} = $interact;
						$interactHash{"base".$bpCount."PDBres"} = $pdbResOuter1;
						$interactHash{"base".$bpCount."chain"} = $chain1;
						$bpCount++;
						$interactHash{"base".$bpCount."SeqPos"} = $n2Number;
						$interactHash{"base".$bpCount."PDBres"} = $pdbResOuter2;
						$interactHash{"base".$bpCount."chain"} = $chain2;
						$interactHash{"base".$bpCount."lw-class"} = $interact;		
					}
					if((uc($chain1) eq $$moHashRef{"chainInner1"}) && ($n1Number == $$moHashRef{"posInner1"}) && (uc($chain2) eq $$moHashRef{"chainInner2"}) && ($n2Number == $$moHashRef{"posInner2"})){
						last;
					}
				}
			}
		}
		close(FR);
		$$moHashRef{"interactHash"} = \%interactHash;
	}
}



1;

