#!/usr/bin/perl


package splitInstance;



use strict;
use warnings;
use Data::Dumper;




## Package to return for a given putative motif  an hash with pdb seq residues and chains
## Input: putative motif instance (format:: Instance: 3DKN F   11 F   25 / F   15 F   23)
## written: 09/03/2012 - corinna






sub splitInstance {

	my $instance = shift;
	my %motifHash;
	if($instance =~ /[\d\w]{4}[\s\t]+[\d\w]+[\s\t]+\d+[\s\t]+[\d\w]+[\s\t]+\d+[\s\t]+\/[\s\t]+[\d\w]+[\s\t]+\d+[\s\t]+[\d\w]+[\s\t]+\d+/gi){
		my @motifArr = split(/[\s\t]+/, $instance);
		## NOTE: pairing partners are posOuter1 and posOuter2 as well as  posInner1 and posInner2
		## NOTE: module region1 = posOuter1-posInner1/posInner2-posOuter2
		$motifHash{"pdb"} = $motifArr[0];
		$motifHash{"chainOuter1"} = uc($motifArr[1]);
		$motifHash{"posOuter1"} = $motifArr[2];
		$motifHash{"chainOuter2"} = uc($motifArr[3]);
		$motifHash{"posOuter2"} = $motifArr[4];
		$motifHash{"chainInner1"} = uc($motifArr[6]);
		$motifHash{"posInner1"} = $motifArr[7];
		$motifHash{"chainInner2"} = uc($motifArr[8]);
		$motifHash{"posInner2"} = $motifArr[9];
	}
	return(\%motifHash);
}


1;
