#!/usr/bin/perl

package createModel;


use FindBin;
use lib "$FindBin::Bin/metaRNAmodules_model/";
use lib "$FindBin::Bin/lib/";
use models_build;
use models_test;
use utils;
use strict;
use warnings;
use Data::Dumper;




sub createModel {

	my ($moHashRef, $strucTabHashRef, $motifFile, $infoHash) = @_;
	my $uniqueOutDir = $$infoHash{"uniqueOutDir"};
	my $modCleanRefseqRfamAli = $$infoHash{"modCleanRefseqRfamAli"};
	my $fam = $$strucTabHashRef{"fam"};
	my $rootPath = $$infoHash{"rootPath"};
	my $stats = $$infoHash{"stats"};
	my $uniqueName = $$moHashRef{"uniqueModuleName"};
	my $rmdoutName = $$infoHash{"rmdoutName"};
	my $rmdoutNameS = $$infoHash{"rmdoutNameS"};
	
	print STDOUT "\#\# Mapping done; Data prepared; Start building model...\n";
	
	my ($defFi, $modelFi) = models_build::startBuild($fam, $moHashRef, $strucTabHashRef, $motifFile, $infoHash);
	
	if(-e $defFi && -e $modelFi){
		## change dir name in fr3d def file
		utils::changeDirectoryName($defFi, $uniqueOutDir, $modCleanRefseqRfamAli, $fam);
		## Exchange MUST PAIR lines in definition file
		utils::changeNodeLines($defFi);
		utils::changeNodeLines($modelFi);
		
    	## run all existing models on test file
		my $fam = $$strucTabHashRef{"fam"};
		models_test::startScan($infoHash, "test");
		
		## shuffle alignment
		utils::shuffleAlignment($infoHash);
		## run new model on shuffled alignments
		models_test::startScan($infoHash, "shuffled");
		chdir $rootPath;
		
		## get discrimination measurement
		my $statsFi = $uniqueOutDir.$uniqueName.".stats";
		if(-e $statsFi){ `rm -f $statsFi`; }
		my $statsCall = $stats." ".$uniqueOutDir." ".$uniqueName." ".$motifFile." ".$statsFi." ".$rmdoutName." ".$rmdoutNameS;
		
		system("$statsCall >>/dev/null");
		
	}
}


1;
