#!/usr/bin/perl


package models_test;



use FindBin;
use lib "$FindBin::Bin/metaRNAmodules_model/";
use lib "$FindBin::Bin/lib/";
use useRMdetectPackage;
use utils;
use strict;
use warnings;
use Data::Dumper;








sub startScan {
	
	my ($infoHash, $flag) = @_;
	
	print STDOUT "\#\# Scan input alignment...please wait\n";
	
	my $tmp = $$infoHash{"tmp"};
	my $rmdetect = $$infoHash{"rmdetect"};
	my $rmcluster = $$infoHash{"rmcluster"};
	my $rootPath = $$infoHash{"rootPath"};
	my $newModelDir = $$infoHash{"uniqueOutDir"};
	my $newTmpRand = utils::getTemporaryDirectory($tmp);
	
	if($flag eq "test"){
		my $ali2scan = $$infoHash{"ali2scan"};
		my $rmdoutName = $$infoHash{"rmdoutName"};
		my $rmcoutName = $$infoHash{"rmcoutName"};
		my $clusterDirName = $$infoHash{"clusterDirName"};
		my $clusterSummary = $$infoHash{"clusterSummary"};
		testModels($rmdetect, $rmcluster, $newTmpRand, $ali2scan, $rmdoutName, $rmcoutName, $clusterDirName, $newModelDir, $clusterSummary, $rootPath, $newTmpRand);
	}
	elsif($flag eq "shuffled"){
		my $ali2scanDir = $$infoHash{"shuffleDir"};
		my $rmdoutNameS = $$infoHash{"rmdoutNameS"};
		my $rmcoutNameS = $$infoHash{"rmcoutNameS"};
		#my $clusterDirNameS = $$infoHash{"clusterDirNameS"};
		my $clusterSummaryS = $$infoHash{"clusterSummaryS"};
		shuffModels($newTmpRand, $newModelDir, $ali2scanDir, $rmdoutNameS, $rmcoutNameS, $clusterSummaryS, $rmdetect, $rmcluster, $rootPath);
	}
}




sub testModels {
	
	my ($rmdetect, $rmcluster, $tmp, $ali2scan, $rmdoutName, $rmcoutName, $clusterDirName, $newModelDir, $clusterSummary, $rootPath, $newTmpRand) = @_;
	
	## set directory names/make tmp directories
	
	## copy models, data and definition file to tmp
	my $defs = $newModelDir."*.def";
	my $mods = $newModelDir."*.model";
	my $datas = $newModelDir."*.data";
	`cp $defs $newTmpRand`;
	`cp $mods $newTmpRand`;
	`cp $datas $newTmpRand`;
	
	## copy alignment to tmp directory
	my @aliPathArr = split(/\//,$ali2scan);
	my $ali2scanName = pop(@aliPathArr);
	my $tmpTestFi = $newTmpRand.$ali2scanName;
	my $newTmpTestFi = "";
	
	if(-e $ali2scan && !-e $tmpTestFi){
		`cp $ali2scan $newTmpRand`;
		if($tmpTestFi =~ /\.gz$/){
			`gzip -d $tmpTestFi`;
			$tmpTestFi =~ s/\.gz//g;
		}
		## change alignment suffix to stk
		if($tmpTestFi =~ /\.sto$/){
			$newTmpTestFi = $tmpTestFi;
			$newTmpTestFi =~ s/sto/stk/g;
			`mv $tmpTestFi $newTmpTestFi`;
		}
		else{ $newTmpTestFi = $tmpTestFi; }
	}
	my $rmdout = $newTmpRand.$rmdoutName;
	my $rmcout = $newTmpRand.$rmcoutName;
	my $clusterDir = $newTmpRand.$clusterDirName;
	my $cluscontenttmp = $newTmpRand."tmp_".$clusterSummary;
	my $cluscontent = $newModelDir.$clusterSummary;
	
	open(CC, ">>$rmcout") or die;
	chdir $newTmpRand;
					
	useRMdetectPackage::testModel($newTmpRand, $rmdetect, $newTmpTestFi, $rmdout);				
	if(-e $rmdout){
		
		useRMdetectPackage::clusterResults($rmcluster, $rmdout, $cluscontenttmp, $newTmpRand, $clusterDir);
		
		`rmdir --ignore-fail-on-non-empty $clusterDir`;
		if(-d $clusterDir){
			opendir(CL, $clusterDir) or die;
			my @clusterdirArr = readdir(CL);
			close(CL);
			## write all in one file
			foreach my $clusi(@clusterdirArr){
				if($clusi =~ /^cluster/){
					
					print CC $clusi."\n\n";
					open(CCO, "<".$clusterDir.$clusi) or die;
					while(<CCO>){
						chomp($_);
						print CC $_."\n";
					}
					close(CCO);
					print CC "\n\n\n";
				}
			}
			`cat $cluscontenttmp >> $cluscontent`;
			`rm -rf $clusterDir`;
		}
	}
	close(CC);
	
	copyData($rmdout, $rmcout, $cluscontent, $newTmpRand,$newModelDir);
	chdir $rootPath;
}







sub copyData {
	
	my ($rmdout, $rmcout, $cluscon, $newTmpRand, $newModelDir) = @_;
	if(-e $rmdout){ `gzip -9 $rmdout`; my $rmdzip = $rmdout.".gz"; `mv $rmdzip $newModelDir`; }
	if(-e $rmcout){ `gzip -9 $rmcout`; my $rmczip = $rmcout.".gz"; `mv $rmczip $newModelDir`; }
	if(-e $cluscon){ `gzip -9 $cluscon`; }
	`rm -rf $newTmpRand`;
}






sub shuffModels {
		
	my ($newTmpRand, $newModelDir, $ali2scanDir, $rmdoutNameS, $rmcoutNameS, $clusterSummaryS, $rmdetect, $rmcluster, $rootPath) = @_;		
	
	## change working directory
	chdir $newTmpRand;
	
	## copy alignments to tmp directory
	my $alis = $newModelDir.$ali2scanDir;
	opendir(AL, $alis) or die;
	my @aliArr = readdir(AL);
	close(AL);
	
	foreach my $al(@aliArr){
		if(!-e $newTmpRand.$al && $al =~ /^perm/){
			`cp $newModelDir$ali2scanDir$al $newTmpRand`;
			`gzip -d $newTmpRand$al`;
		}
	}
	
	## copy models and stuff to tmp directory
	my $modelstuff = $newModelDir."*";
	my $mods = $newModelDir."*.model";
	my $dats = $newModelDir."*.data";
	my $defs = $newModelDir."*.def";
	`cp $mods $newTmpRand`;
	`cp $dats $newTmpRand`;
	`cp $defs $newTmpRand`;

	opendir(PD, $newTmpRand) or die;
	my @permArr = readdir(PD);
	close(PD);
	
	my $rmdd = $newTmpRand.$rmdoutNameS;
	my $rmt = $newTmpRand.$rmcoutNameS;
	my $cluscontent = $newTmpRand.$clusterSummaryS;
	
	foreach my $permfi(@permArr){
		if($permfi =~ /^perm/){
			my $perm = $newTmpRand.$permfi;
			runRMD($perm, $newTmpRand, $rmdetect, $rmcluster, $rootPath, $rmdd, $rmt, $cluscontent);
		}
	}
	copyShuffData($rmdd, $rmt, $cluscontent, $newModelDir);
	chdir $rootPath;
	`rm -rf $newTmpRand`;
}






sub runRMD {

	my ($tmppermfall, $newTmpRand, $rmdetect, $rmcluster, $rootPath, $rmdd, $rmt, $cluscontent) = @_;
	my $permnu = 1;
	my $flag = "FALSE";
	open(RMDD, ">>$rmdd") or die "\nCan't open $rmdd\n\n";
	open(RC, ">>$rmt") or die "\nCan't open $rmt\n\n";
	open(CC, ">$cluscontent") or die "\nCan't open $cluscontent\n\n";
	
	open(PE, "<$tmppermfall") or die;
	my $tmppermfi = "";
	my $coco = 1;
	my %clustalHash;
                                
	while(<PE>){
		chomp($_);
		if($_ =~ /^CLUSTAL/){
			if($flag eq "FALSE"){
				$clustalHash{$coco} = "CLUSTAL W(1.81) multiple sequence alignment";
				$flag = "TRUE";
				$coco++;
			}
			else{
				my $tmppermf = printTmpAli(\%clustalHash, $permnu, $newTmpRand);
				
				runRM($tmppermf, $permnu, $newTmpRand, $rmdetect, $rmcluster);
				%clustalHash = ();
				$coco = 1;
				$clustalHash{$coco} = "CLUSTAL W(1.81) multiple sequence alignment";
				`rm -rf $tmppermf`;
				$tmppermfi = "";
				$coco++;
				$permnu++;
			}
		}
		else{
			$clustalHash{$coco} = $_;
			$coco++;
		}
	}
	close(PE);
	my $tmppermf = printTmpAli(\%clustalHash, $permnu, $newTmpRand);
	runRM($tmppermf, $permnu, $newTmpRand, $rmdetect, $rmcluster);
	close(RC);
	close(CC);
	close(RMDD);
}



sub runRM {

	my ($tmppermf, $peru, $newTmpRand, $rmdetect, $rmcluster) = @_;
    my $rmdout = $newTmpRand."/shuffled_perm".$peru."_tmp.rmdout";
	my $rmcout = $newTmpRand."/shuffled_perm".$peru."_tmp.rmcout";
	my $clusOutDir = $newTmpRand."/clusters_shuffled_".$peru."/";
	
	useRMdetectPackage::testModel($newTmpRand, $rmdetect, $tmppermf, $rmdout);
	print RMDD "\n\n\nPERM ".$peru."\n";
        
	if(-e $rmdout){
        
		open(DO, "<$rmdout") or die;
		while(<DO>){
			chomp($_);
			print RMDD $_."\n";
		}
		close(DO);


		useRMdetectPackage::clusterResults($rmcluster, $rmdout, $rmcout, $newTmpRand, $clusOutDir);
              
		print RC "\n\n\nPERM ".$peru."\n";
		open(TR, "<$rmcout") or die;
		while(<TR>){
			chomp($_);
			print RC $_."\n";
		}
		close(TR);
		`rm -rf $rmcout`;       
		`rmdir --ignore-fail-on-non-empty $clusOutDir`;
        
		if(-d $clusOutDir){
			opendir(CD,$clusOutDir) or die;
 			my @clusterdirArr = readdir(CD);
			close(CD);
			print CC "\n\n\nPERM ".$peru."\n";
                        
			foreach my $clusi(@clusterdirArr){
				if($clusi =~ /^cluster/){
					print CC $clusi."\n\n";
                                
					open(CCO, "<".$clusOutDir.$clusi) or die;
					while(<CCO>){
						chomp($_);
						print CC $_."\n";
					}
					close(CCO);
					print CC "\n\n";
				}
			}
			`rm -rf $clusOutDir`;
		}
	}
	`rm -f $rmdout`;
}





sub printTmpAli {

        my ($clustalHash,$permn, $newTmpRand) = @_;
        my @sortKeys = sort { $a <=> $b } keys %$clustalHash;
        my $tmppermfi = $newTmpRand."_random".$permn.".aln";
        open(TM, ">$tmppermfi") or die;
        foreach my $k(@sortKeys){
                my $val = $$clustalHash{$k};
                print TM $val."\n";
        }
        close(TM);
        return($tmppermfi);
}








sub copyShuffData {

	my ($rmdout, $rmcout, $cluscon, $newModelDir) = @_;
	
	if(-e $rmdout){
		`gzip -9 $rmdout`;
		my $newrmdout = $rmdout.".gz";
		`mv $newrmdout $newModelDir`;
	}
	if(-e $rmcout){
		`gzip -9 $rmcout`;
		my $newrmcout = $rmcout.".gz";
		`mv $newrmcout $newModelDir`;
	}
	if(-e $cluscon){
		`gzip -9 $cluscon`;
		my $newcluscon = $cluscon.".gz";
		`mv $newcluscon $newModelDir`;
	}
}

1;
