#!/usr/bin/perl


use lib "/rth/corinna/Scripts_NewModels/";

use useRMdetectPackage;
use strict;
use warnings;
use Data::Dumper;


my $x = $ARGV[0];
my $newModelDir = $ARGV[1];
my $mofile = $ARGV[2];
my $tmp = $ARGV[3];
my $rmDir = $ARGV[4];


## directories
#my $tmp = "/tmp/";
my $newTmpRand = $tmp."randshuffled_";
my $numDir = "";
my $numNewModelDir = $newModelDir.$x."/";

my $rmddName = "shuffled_".$x."_all.rmdout";
my $rmdd = "";

my $rmtName = "shuffled_".$x."_summary.rmcout";
my $rmt = "";

my $cluscontentName = "shuffled_".$x."_all.rmcout";
my $cluscontent = "";



## tools
#my $rmDir = "/usr/local/bin/";
my $rmdetect = $rmDir."rmdetect.py";
my $rmcluster = $rmDir."rmcluster.py";



my $fam = "";
my $class = "";
my $pdb = "";

my $range = 1000000;
my $minimum = 5000000;
my $permnu = 1;



#my $host = `hostname`;
#chomp($host);
#print STDOUT "\n\nHostname:  ".$host."\n\n";
print STDOUT "\n\nRun RMdetect/RMcluster with all available models (fr3d, pebl) on shuffled data\n";
print STDOUT "Script: models_test_shuffled_newnew.pl\n";
print STDOUT "------------------------------\n\n";



my $moHashRef = getMotifInfo();
#print Dumper $moHashRef;
processMotifs();



sub processMotifs {
				
	$fam = $$moHashRef{"fam"};
	$class = $$moHashRef{"class"};
	$pdb = $$moHashRef{"pdb"};


	my $random_number = int(rand($range)) + $minimum;
	#print $random_number."   random_number\n";



	$newTmpRand .= $random_number."/";
	if(!-d $newTmpRand){ `mkdir $newTmpRand`; }
	else{
		while(-d $newTmpRand){
			$random_number = int(rand($range));
			$newTmpRand .= $random_number."/";
		}
		`mkdir $newTmpRand`;
	}

	$numDir = $newTmpRand.$x."/";
	if(!-d $numDir){ `mkdir $numDir`; }


	## change working directory
	chdir $numDir;


	## copy alignments to tmp directory
	my $alis = $newModelDir.$fam."_mod_random.aln.gz";
	#print "\n\nALIS:   $alis\n\n";
	my $tmpalis = $numDir.$fam."_mod_random.aln.gz";
	if(!-e $tmpalis){
		`cp $alis $numDir`;
		`gzip -d $tmpalis`;
	}
	$tmpalis =~ s/\.gz//g;
	
	
	## copy models and stuff to tmp directory
	my $modelstuff = $numNewModelDir."*";
	my $mods = $numNewModelDir."*.model";
	my $dats = $numNewModelDir."*.data";
	my $defs = $numNewModelDir."*.def";
	#`cp -r $modelstuff $numDir`;
	`cp $mods $numDir`;
	`cp $dats $numDir`;
	`cp $defs $numDir`;

	opendir(PD, $numDir) or die;
	my @permArr = readdir(PD);
	close(PD);
	#print Dumper \@permArr;
	$rmdd = $numDir.$fam."_".$class."_".$pdb."_".$rmddName;
	open(RMDD, ">>$rmdd") or die;
	#print "RMDD:   $rmdd\n\n";
	$rmt = $numDir.$fam."_".$class."_".$pdb."_".$rmtName;
	open(RC, ">>$rmt") or die;
	#print "RMT:   $rmt\n\n";
	$cluscontent = $numDir.$fam."_".$class."_".$pdb."_".$cluscontentName;
	open(CC, ">$cluscontent") or die;
		
	foreach my $permfi(@permArr){
		chdir $numDir;
		if($permfi =~ /^$fam\_mod\_random\.aln/){
			
			my $flag = "FALSE";
					
			open(PE, "<$permfi") or die;
			my $tmppermfi = "";
			my $coco = 1;
			my %clustalHash;
			
			while(<PE>){
				chomp($_);
				
				if($_ =~ /^CLUSTAL/){
					
					if($flag eq "FALSE"){
						$clustalHash{$coco} = "CLUSTAL W(1.81) multiple sequence alignment";
						$flag = "TRUE";
						$coco++;
					}
					else{
						my $tmppermf = printTmpAli(\%clustalHash, $permnu);
						runRM($tmppermf, $permnu);
						%clustalHash = ();
						$coco = 1;
						$clustalHash{$coco} = "CLUSTAL W(1.81) multiple sequence alignment";
						`rm -rf $tmppermf`;
						$tmppermfi = "";
						$coco++;
						$permnu++;
					}
				}
				else{
					$clustalHash{$coco} = $_;
					$coco++;
				}
			}
			close(PE);
			my $tmppermf = printTmpAli(\%clustalHash, $permnu);
			runRM($tmppermf, $permnu);
		}
	}
	close(RC);
	close(CC);
	
	copyData($rmdd,$rmt,$cluscontent);
	#`rm -rf $newTmpRand`;
}






sub runRM {

	my ($tmppermf, $peru) = @_;
	my $rmdout = $numDir."shuffled_".$x."_perm".$peru."_tmp.rmdout";
	my $rmcout = $numDir."shuffled_".$x."_perm".$peru."_tmpsum.rmcout";
	my $clusOutDir = $numDir."clusters_shuffled_".$peru."/";
	
	useRMdetectPackage::testModel($numDir, $rmdetect, $tmppermf, $rmdout);
	print RMDD "\n\n\nPERM ".$peru."\n";
	#print "\n\n\nPERM ".$peru."\n";
	open(DO, "<$rmdout") or die;
	while(<DO>){
		chomp($_);
		print RMDD $_."\n";
	}
	close(DO);
	#print "\n\nRMDD:  $rmdd\n\n";
	if(-e $rmdout){
		
		useRMdetectPackage::clusterResults($rmcluster, $rmdout, $rmcout, $numDir, $clusOutDir);
		
		print RC "\n\n\nPERM ".$peru."\n";
		open(TR, "<$rmcout") or die;
		while(<TR>){
			chomp($_);
			print RC $_."\n";
		}
		close(TR);
		`rm -rf $rmcout`;	
		`rmdir --ignore-fail-on-non-empty $clusOutDir`;
		
		if(-d $clusOutDir){
			opendir(CD,$clusOutDir) or die;
			my @clusterdirArr = readdir(CD);
			close(CD);
			print CC "\n\n\nPERM ".$peru."\n";
			
			foreach my $clusi(@clusterdirArr){
				if($clusi =~ /^cluster/){
					print CC $clusi."\n\n";
				
					open(CCO, "<".$clusOutDir.$clusi) or die;
					while(<CCO>){
						chomp($_);
						print CC $_."\n";
					}
					close(CCO);
					print CC "\n\n";
				}
			}
			`rm -rf $clusOutDir`;
		}
	}
	`rm -f $rmdout`;
}






sub printTmpAli {

	my ($clustalHash,$permn) = @_;
	my @sortKeys = sort { $a <=> $b } keys %$clustalHash;
	my $tmppermfi = $numDir.$fam."_mod_random".$permn.".aln";
	open(TM, ">$tmppermfi") or die;
	foreach my $k(@sortKeys){
		my $val = $$clustalHash{$k};
		print TM $val."\n";
	}
	close(TM);
	return($tmppermfi);
}






sub copyData {

	my ($rmdout, $rmcout, $clusOutDir) = @_;
	if(-e $rmdout){
		`gzip -9 $rmdout`;
		my $newrmdout = $rmdout.".gz";
		`mv $newrmdout $numNewModelDir`;
	}
	if(-e $rmcout){
		`gzip -9 $rmcout`;
		my $newrmcout = $rmcout.".gz";
		`mv $newrmcout $numNewModelDir`;
	}
	if(-e $clusOutDir){
		`gzip -9 $clusOutDir`;
		my $newclusOutDir = $clusOutDir.".gz";
		`mv $newclusOutDir $numNewModelDir`;
	}
	
}






sub getMotifInfo {
		
		my $fam = "";
		my $class = "";
		my $pdb = "";
		my $org = "";
		my $upos = "";
		my $gpos = "";
		my $of = "F";
		my $moseq = "";
		my $moRep = "";
		my $dobra = "";
		my $bps = "";
		my %moHash;
		`cp $mofile $tmp`;
		my @pathArr = split(/\//,$mofile);
		my $mofiname = $pathArr[7];
		my $tmpmofi = $tmp.$mofiname;
		`gzip -d $tmpmofi`;
		$tmpmofi =~ s/\.gz//g;
		
		open(FI, "<".$tmpmofi) or die "\nCan't open $tmpmofi\n\n";
		while(<FI>){
			chomp($_);
			
			if($_=~/\d+[\s\t]+\*+/g){
				$of = "T";
			}
			elsif($_=~/^PDB\:[\s\t]+(\d{1}[\w\d]{3})/){
				$pdb = $1;
				$moHash{"pdb"} = $pdb;
			}
			elsif($_=~/^RFAM\:[\s\t]+(RF0\d+)/){
				$fam = $1;
				$moHash{"fam"} = $fam;
			}
			elsif($_=~/^class\:[\s\t]+(\d+)/){
				$class = $1;
				$moHash{"class"} = $class;
			}
			elsif($_ =~ /^ORG\:[\s\t]+([\w\d\.\-\/]+)/){
				$org = $1;
				$moHash{"org"} = $org;
			}
			elsif($_=~/^ungapSeedAliPos:[\s\t]+([\d\-\/]+)/){
				$upos = $1;
				$moHash{"upos"} = $upos; 
			}
			elsif($_=~/^gapSeedAliPos:[\s\t]+([\d\-\/]+)/){
				$gpos = $1;
				$moHash{"gpos"} = $gpos; 
			}
			elsif($_=~/^PuMo\:[\s\t]+([\w\&]+)/g){
				$moseq = $1;
				$moHash{"moseq"} = $moseq;
			}
			elsif($_=~/(\<[\w\d\:\,]+\>)/g){
				$moRep = $1;
				$moHash{"morep"} = $moRep;
			}
			
			elsif($_=~/^DOBRA\:[\s\t]+([\(\)\.\<\>\{\}]+[\(\)\.\<\>\{\}\d]*)/g){
				$dobra = $1;
				$moHash{"dobra"} = $dobra;
			}
			elsif($_=~/^BP[\s\t]+\d+\:[\s\t]+(\d+)[\s\t]+(\d+)[\s\t]+[\(\)A-Za-z]+/){
				$bps .= $2;
				$bps .= "*";
				$bps .= $1;
				$bps .= "+";
			}
		}
		close(FI);
		chop($bps);
		$moHash{"bps"} = $bps;
		`rm $tmpmofi`;
		#`gzip -9 $mofile`;
		#print Dumper \%moHash;
		return(\%moHash);
}




















