{-# LANGUAGE StandaloneDeriving #-}
{-# LANGUAGE DoAndIfThenElse #-}
{-# LANGUAGE RecordWildCards #-}
{-# LANGUAGE DeriveDataTypeable #-}

module Main where

import Data.Either
import Data.List (sort,groupBy,sortBy,nub,nubBy)
import Data.Ord (comparing)
import System.Console.CmdArgs
import Text.Printf

import qualified Biobase.FR3D as FR3D
import qualified Biobase.FR3D.Import as FR3D

import BioInf.RNAmodule.Putative



-- ** main

main = do
  o <- cmdArgs $ modes [putative]
  runO o

runO Putative{..} = do
  fr3ds <- (map FR3D.checkFR3D) `fmap` FR3D.fromDir sourceDir
  let rs' = rights fr3ds
  let ls' = lefts fr3ds
  let linfr3ds = map ( FR3D.checkLinFR3D
                     . FR3D.removeDuplicatePairs
                     . FR3D.linearizeFR3D
                     ) rs'
  let ls = lefts linfr3ds
  let rs = rights linfr3ds
  if null ls
  then do
    let motifs = concatMap (\r -> map (mkLocal $ FR3D.sequence r)
                               . putativeMotifs
                               $ r
                            )
               $ rs
    let gms = reverse
            . sortBy (comparing length)
            $ collectBy sameMotif motifs
    printf "Total number of motifs: %d, unique motifs according to 'sameMotif': %d\n" (length motifs) (length gms)
    mapM_ (\ms -> printf "Instances of motif: %d\n" (length ms)
               >> mapM_ viewMotif (nubBy eqMotif ms)
               >> mapM_ origin ms >> putStrLn "\n"
            ) gms
  else do
    putStrLn "errors:"
    mapM_ (\l -> print (fst l) >> mapM_ print (snd l) >> putStrLn "") ls

-- ** cmdargs handling

data Options
  = Putative
    { sourceDir :: FilePath
    }
  deriving (Show,Data,Typeable)

putative = Putative
  { sourceDir = "./" &= args
  }

