#!/usr/bin/perl
# use strict;
use Getopt::Long;
use FileHandle;
use Fcntl;
use Sys::Hostname;
use Time::localtime;
my $scr_name = $0;
$filemode = '0744';
$filemode = oct($filemode);
$opt_Z = 0;
$homedir = $ENV{HOME};
my $tmp_dir = undef;
Getopt::Long::Configure("no_ignore_case");
&GetOptions("R","O","I","C","T","D","p","m","h","Q","w",
	    "e=s","c=s","q=s","o=s","s=s",
	    "Z=s"  => \$opt_Z,
	    "B=s"  => \$homedir,
	    "Bw:s" => \$tmp_dir);
if ($opt_h) {
    print "Usage: pbsubmit -c \"command\" [-p] [-q queue] ";
    print "[-s shell] [-e environment] [-o qsub options] [-p] [-C] [-I]\n";
    print "[-Z skeleton]\n\n";
    print "Options: \n";
    print "[-h] Prints out this message.\n";
    print "[-e environment] selects a PBS environment settiing. (not implemented)\n";
    print "[-m] emails you when the job begins and ends.\n";
    print "[-o qsub options] passes options to the call to qsub.\n";
    print "[-p] begins the script in your present working directory.\n";
    print "[-q queue] selects a queue.\n";
    print "[-s shell] selects a shell.\n";
    print "[-C] writes a comment in the script for convenience.\n";
    print "[-I] uses qsub's interactive mode. \n";
    print "[-O] Overrides sleep-mode (which I use for letting load averages creep up.\n";
    print "[-R] submits a second job as a failsafe.\n";
    print "[-T] Test mode. Only writes the script, but does not submit it for queuing.\n";
    print "[-D] Do NOT delay.\n";
    print "[-B <base dir>] set the temporary dir for the script creation (default ~/.pbsrc/).\n";
    print "[-Bw [<base dir>]] create unique temporary dir for the script creation (default ~/.pbsrc_<date>_pid/\n";
    print "		      wait for the job to finish, this directory will be cleaned when the job is done\n";
    print "[-Q] quiet (do not print 'Openning pbsjob...' and 'qsub ...').";
    print "[-w] wait for the job to finish.\n";
    print "[-Z skeleton arguments ] (In Beta) Generates a sequence of jobs from a skeleton file \n";
    print "[-P] (Not yet implemented.) Writes the settings for a LAM-MPI job.\n";
    exit ;
}
if (defined $tmp_dir){
    $tmp_dir = $ENV{HOME}  if (not -d $tmp_dir);
    my $now = sprintf("%02d_%02d_%02d:%02d:%02d",
		localtime->mon()+1, 
		localtime->mday(),
		localtime->hour(),
		localtime->min(),
		localtime->sec()
		);
    $tmp_dir = $tmp_dir . "/.pbsubmit_${now}" . "_" . $$ . "_" . hostname();
    $opt_w = 1;
    $homedir = $tmp_dir;
    mkdir("$homedir",0744)||die "cannot create directory $homedir - $!\n";
}
my $pbsubmit_time="/tmp/ttt.$ENV{USER}";
# delay to let load averages settle
#define	LOCK_SH	1	/* Shared lock.  */
#define	LOCK_EX	2 	/* Exclusive lock.  */
#define	LOCK_UN	8	/* Unlock.  */
##/* Can be OR'd in to one of the above.  */
#define	LOCK_NB	4
if (!$opt_O) {
    autoflush STDOUT 1;
    $curtime = time; 

    open (TIMEFILE, "$pbsubmit_time")||
     open (TIMEFILE, ">$pbsubmit_time")|| 
	die "could not open $pbsubmit_time\n";
    unless ( flock(TIMEFILE , 1 | 4)){
	local $| =1 ;
	print "Waiting for lock on timing file.\n" unless (defined $opt_Q);
        flock(TIMEFILE, 1) or die "Can't lock timing file.\n";
    }
    $opt_O = <TIMEFILE>;
    $filetime = $opt_O;

#    close(TIMEFILE);
#    open (TIMEFILE, ">$pbsubmit_time")||
#	die "could not open $pbsubmit_time\n";

#    print TIMEFILE "$curtime\n";

    unless ($opt_D) {
	if ($curtime < $filetime) {
	    print STDERR "Delay set in to prevent overshoots. Use &.\n" unless (defined $opt_Q);
	    print STDERR "Dum dee dum.. " unless (defined $opt_Q);
	    while ($curtime < $filetime) {
		sleep 4;
		print STDERR ".zz." unless (defined $opt_Q);
		$curtime = time;
	    }
	    print STDERR "\n*Yawn*... back to work for me.\n" unless (defined $opt_Q);
	}
    }
#
# set delay for 10 seconds
#
    $filetime = $curtime +10;
    close(TIMEFILE);
    sysopen(TIMEFILE, "$pbsubmit_time", O_WRONLY | O_CREAT)
	or die "could not open $pbsubmit_time\n";
    flock(TIMEFILE, 1)
	or die "could not lock $pbsubmit_time\n";
    truncate(TIMEFILE,0)
	or die "could not truncate  $pbsubmit_time\n";
#    open (TIMEFILE, ">$pbsubmit_time")||
#	
    print TIMEFILE "$filetime\n";
    close(TIMEFILE);
}
if ($opt_m) {
    $opt_m = "-m abe -M " . $opt_m;
}

$new_job = &get_jobfile_number();
print STDERR "Openning $new_job\n" unless (defined $opt_Q);

die "$new_job already exists. Time to purge .pbsrc.\n" if -e $new_job;

if (!$opt_s) {
    $opt_s = "/bin/sh";
}
if (!$opt_c) {
    die "No command specified. Exiting.\n";
}
if ($opt_q){
    $opt_q = "-q " . $opt_q;
}
if ($opt_C) {
    print "-C invoked. Please give this job a name or comment. (One line.) \n";
    $opt_C = <STDIN>;
    print JOBFILE "#COMMENT: $opt_C \n";
}


$JobFile = new FileHandle "> $new_job"; 

if (defined $JobFile) {
    &print_jobfile_header($JobFile);
} else {
    die "Could not open $new_job to print the header.\n";
}

$job_status = $new_job;
$job_status .= ".status" ;

&handle_jobfile_options($JobFile) ;
&print_jobfile_command($JobFile,$homedir,$job_status);
&print_jobfile_footer($JobFile, $homedir, $job_status);
$JobFile->close;

chmod (0755, $new_job);
if ($opt_I) {
    $opt_o = "-I " . $opt_o;
}

$frobfile = new FileHandle "> $job_status";

if (defined $frobfile ) { 
    $frobfile->autoflush(1);
    &print_statusfile_header($frobfile); 
} else {die "Could not open status file $job_status.\n";}

print "qsub $opt_o $opt_q $homedir/.pbsrc/$new_job \n" unless (defined $opt_Q);
#test mode...
if ($opt_T ) {
    print $frobfile "# Script was not queued in. User invoked -T option.\n";
} else { 

    open(QSUBPROC, "qsub $opt_o $opt_m $opt_q $homedir/.pbsrc/$new_job 2>&1 |");
    select(QSUBPROC);
    $| =1;
    select(STDOUT);
    
#get a good qsub parse!!!
    print $frobfile $opt_C;
    while (<QSUBPROC>) {
	print $frobfile "Queued $_";
	print STDOUT $_;
	s/[^\d]//g;
	$qsub_output = $_;
    }
    close QSUBPROC;
    if ($opt_R) {
	$opt_m =~ s/-m abe/-m be/;
# retries.
#    print "qsub $opt_o $opt_q -W depend=afternotok:$qsub_output";
#    print	" $homedir/.pbsrc/$new_job\n ";
	open(QSUBPROC2,
	     "qsub $opt_o $opt_q $opt_m -W depend=afternotok:$qsub_output $homedir/.pbsrc/$new_job  |");
	select(QSUBPROC2);
	$| =1;
	select(STDOUT);

#    print $frobfile $opt_C;
	
	while (<QSUBPROC2>) {
	    print $frobfile "queued $_";
	    
	    print STDOUT $_;
	}
	close QSUBPROC2;

    }
}
$frobfile->close;
$frobfile->open(">>$job_status") ||
    die "Could not reopen $job_status.\n";
print $frobfile "#and the job is...\n\n\n";
$frobfile->close;

#
# if -w (wait) option is given - wait for the job to finish 
#
if ($opt_w){
    sleep 5;
    system "waitjob.pl $qsub_output";
    if (defined $tmp_dir){
	unlink glob "$tmp_dir/.pbsrc/* $tmp_dir/.pbsrc/*";
	rmdir "$tmp_dir/.pbsrc" or warn "$scr_name : could not remove $tmp_dir/.pbsrc : $!\n";
	unlink glob "$tmp_dir/* $tmp_dir/.*";
	rmdir $tmp_dir or warn "$scr_name : could not remove $tmp_dir\n";
    }
}
#================================================================================
######################
# handle_jobfile_options
#
######################
sub handle_jobfile_options  {
    my ($filehandle) = @_;
    if (defined $filehandle ) { 
	if ($opt_e) {
	    print $filehandle "# setting directives for PBS: \n";
	    print $filehandle "#PBS -l $opt_e \n";
	}
	if ($opt_p) {
	    $opt_p = $ENV{"PWD"};
	    print $filehandle "# implementing option -p\n";
	    print $filehandle "cd $opt_p \n" ;
	}

    }
} 



########################
# get_jobfile_number
#
# gets a new jobfile number.
########################
sub get_jobfile_number {

    my ($new_job, $last_job, @jobs_dir) ;
    unless(opendir(JOBSDIR, "$homedir/.pbsrc")) {
	print STDERR "no .pbsrc directory. Making one. \n" unless (defined $opt_Q);
	mkdir("$homedir/.pbsrc",0744)  ||
	    die "Could not make .pbsrc. Something is wrong.\n\n" ;
	
    }
    @jobs_dir = grep /pbsjob_[1234567890]+$/, readdir JOBSDIR;
#    print @jobs_dir;
    closedir JOBSDIR;
    chdir "$homedir/.pbsrc" || die "Could not chdir to .pbsrc";
    
    if ($#jobs_dir > 1000) {
	print "It may be time to purge .pbsrc. \n" unless (defined $opt_Q);
    }
    $new_job=0;
    foreach $last_job (@jobs_dir) {
	$last_job =~ s/^pbsjob_// ;

	if ($last_job > $new_job) {
	    $new_job = $last_job ;
	}
    }
    $new_job ++; 
    $new_job = "pbsjob_$new_job";
    return $new_job;

}

###################

# print_jobfile_command : prints
# command part of a job file.
#
###################

sub print_jobfile_command { 

    my ($filehandle,$homedir, $job_status) = @_;
    if (defined $filehandle ) {

	print $filehandle "#These lines added for accounting while job runs:\n";
	print $filehandle "hostname >>   $homedir/.pbsrc/$job_status\n";
	print $filehandle "echo running `date` >> $homedir/.pbsrc/$job_status\n";
	

	print $filehandle "# The command submitted was:\n";
	$tmp_opt_c = $opt_c;
	$tmp_opt_c =~ s/\n/ /g;
	$opt_c = $tmp_opt_c;
	print $filehandle "# CMD: $tmp_opt_c\n";
	if ($opt_P) { print $filehandle '#'; } 
	print $filehandle "$opt_c\n";
	if ($opt_P) { 
# set for LAM-MPI. Other implementations will require other things
	    print $filehandle "# The -P flag is set for parallel execution.\n";
	    print $filehandle "# $opt_P nodes are requested, hence the line below:.\n";
	    print $filehandle "#PBS -l nodes=$opt_P \n";
	    print $filehandle "# Now a few setup commands. The job will run on these process
ors: \n";
	    print $filehandle "echo machines used: >>  $homedir/.pbsrc/$job_status\n";
	    print $filehandle "echo `cat `\$PBS_NODEFILE` >>  $homedir/.pbsrc/$job_status\n"
		;
	    print $filehandle "NPROCS=`wc -l < \$PBS_NODEFILE`";
	    if ($opt_P eq 'mpich' ) {
		print $filehandle "# the chosen implementation is MPICH, hence this:\n";
		print $filehandle "mpirun -v -machinefile $PBS_NODEFILE -np $NPROCS $opt_c\n
";
	    } elsif ($opt_P eq 'lam' ) {
		print $filehandle "# the chosen implementation is LAM, hence this:\n";
# command line needs a double dash...
		print $filehandle "lamboot -v \$PBS_NODEFILE\n";
		$opt_c =~ s/\b/ -- /;
		print $filehandle "mpirun -v C $opt_c\n";
		print $filehandle "wipe -v \$PBS_NODEFILE\n"
	    } 

#    $mpi_nodes = `cat $PBS_NODEFILE`; 
#to do: reparse opt_c for mpirun.
# add a version of lamboot.
# add mpirun. add lamclean
	    
	}
    }
}


###################
# print_jobfile_header : prints the beginning
# (and unchanging) part of a job file.
#
###################

sub print_jobfile_header { 

    my ($filehandle) = @_;

    if (defined $filehandle ) { 

	print $filehandle "#!$opt_s\n";
	print $filehandle "# This file was generated automatically.\n";
	print $filehandle "# on DATE ";
	print $filehandle scalar localtime;
	print $filehandle "\n";
    }
}

###################
# print_jobfile_footer : prints the final
# (and unchanging) part of a job file.
#
###################

sub print_jobfile_footer { 

    my ($filehandle,$homedir,$job_status) = @_;

    if (defined $filehandle ) { 
	print $filehandle "#This line added for error number accounting: \n";
	print $filehandle "PBS_ERR=\$?\n";
	print $filehandle "# These lines added for accounting:\n";
	print $filehandle "echo done `date` status \${PBS_ERR} >> $homedir/.pbsrc/$job_status\n";

	print $filehandle "exit \$PBS_ERR";

    }
}
###################
# print_statusfile_header : prints the beginning
# (and unchanging) part of a status file.
#
###################

sub print_statusfile_header { 

    my ($filehandle) = @_;

    if (defined $filehandle ) { 

	print $filehandle "# This file was generated automatically.\n"; 
	print $filehandle "#\n";
	print $filehandle "# The command submitted was:\n";
	print $filehandle "$opt_c\n";
	print $filehandle "#qsub command line options used were: \n";
	print $filehandle "$opt_o\n";
	print $filehandle "#the shell selected was $opt_s\n";
	
	print $filehandle "#the queue: $opt_q\n";
	print $filehandle "#the qsub command output: \n";

    }
}

