#!/usr/bin/python

import sys
import csv

def unique_interval(intervals, start, end):
    for (istart, iend) in intervals:
        if (start>=istart and start<=iend) or (end>=istart and end<=iend) or (start<istart and end>iend):
            return False
    return True

intervals={}

file = sys.argv[1]
with open(file) as f:
    rd = csv.reader(f, delimiter="\t")
    for line in rd:
        try:
            start=int(line[0])
            end=int(line[1])
            if unique_interval(intervals, start, end) == True:
                intervals[start,end]=line
        except ValueError:
            header=line # it was a string and not an int

print("\t".join(header))
for line in sorted(intervals.values(), key=lambda x:float(x[2]), reverse=True):
    print("\t".join(line))
