#!/bin/bash

# program to generate windows centered around the structured RNA regions and extract the corresponding maf alignments

module load hg

outdir=dataset/windows

for win in 100 150 200;
do 
  # create a bed file with window of win size around structure mid-point
  zgrep ^chr dataset/annotations/all_filtered_annotations.bed.gz | perl -MPOSIX -sane '$midpoint=ceil(($F[2]+$F[1]+1)/2);$flank=$win/2;print $F[0],"\t",($midpoint-$flank-1),"\t",($midpoint+$flank),"\t",join("\t",@F[1..$#F]),"\n";' -- -win=$win >$outdir/window_${win}.bed

  # extract the mafs for the structured centered windows
  mafsInRegion $outdir/window_${win}.bed $outdir/out_${win}.maf dataset/alignment/14way.maf.gz
done
