import pandas as pd

def job_start(nextcnt):
    outfile=open("split_jobs/job%s.sh" % nextcnt, 'w')
    outfile.write("#!/bin/bash\n")
    outfile.write("cd /home/projects/rth/rnabound/rnabound_benchmark/benchmark/\n")
    
    return outfile
    
def job_close(outfile):
    outfile.close()

maxjobsdict = {150:8, 200:5}
#maxjobsdict = {100:10, 150:4, 200:3}

nextcnt=0
for win in [150, 200]:
    for flank in [10]:
        lcnt=0
        nextcnt+=1
        maxjobs=maxjobsdict[win]
        print(win, maxjobs)
        data = pd.read_csv("dataset/windows/window_%s_benchmark_data.bed" % win, sep="\t")
        outfile = job_start(nextcnt)
        for idx, row in data.iterrows():
            print(row['chr'], row['window_start'])
            outfile.write("scripts/run_petfold_rnabound.sh %s %s %s %s %s %s %s\n" % (row['chr'], row['window_start'], row['window_end'], row['strand'], win, flank, 0.0005))
            lcnt+=1
            print(idx, lcnt, maxjobs, nextcnt)
            if lcnt==maxjobs:
                job_close(outfile)
                nextcnt+=1
                lcnt=0
                outfile = job_start(nextcnt)
        job_close(outfile)
