import re
import sys
import numpy as np

filename = open(sys.argv[1], "r")
strand = sys.argv[2]

maf_blocks={}
blockcnt=0
mafsize=[]
for line in filename:
    # get the maf blocks
    if line.startswith("a score"):
        maf_blocks["block%s" % blockcnt] = []
        tmpline = line.rstrip()
        for line in filename:
            if line.startswith("\n"):
                blockcnt+=1
                break
            else:
                if 'null' not in line:
                    if 'hg38' in line:
                        mafsize.append(np.int(re.split(" +", line)[3]))
                        
                    maf_blocks["block%s" % blockcnt].append(line.rstrip())
                    
# get the block with maximum length
maxindex = np.argmax(mafsize)

# print fasta sequence
complement = {'A': 'T', 'C': 'G', 'G': 'C', 'T': 'A'}

for seq in maf_blocks["block%s" % (maxindex)]:
    print(">%s" % re.split(" +", seq.rstrip())[1]) # print header for each sequence
    if strand == "+":
        print(re.split(" +", seq.rstrip())[6].upper()) # print the sequence as it is
    elif strand == "-":
        print("".join(complement.get(base, base) for base in reversed(re.split(" +", seq.rstrip())[6].upper()))) # print reverse complementary
