/*
 * header for plateau finding functions
 */
#ifndef RNACOP_PLATEAU_PLATEAU_H
#define RNACOP_PLATEAU_PLATEAU_H

/* ---------------------- get_best_extension --------------------------
 * starting from (idxi, idxj) extends inner area and shifts outer
 * ring to get optimal extension for plateau like area
 * m should contain logarithmic values
 *
 * inside, outside have to be allocated (size M * N)
 * p: percentage to get quantile
 * mindist: determines radius of inner circle
 *
 * output will be written to bestd and bestdiff (single values NOT arrays)
 */
void
get_best_extension(NMMatrix *m, const unsigned long idxi, const unsigned long idxj, const unsigned long mindist, const unsigned long maxdist, const unsigned long owidth, const double p, unsigned long* bestd, double* bestdiff, double *s1, double *s2, double *inside, double *outside);

/* ---------------------- get_best_extension_mean --------------------------
 * starting from (idxi, idxj) extends inner area and shifts outer
 * ring to get optimal extension for plateau like area
 * m should contain proababilities
 *
 * evaluates ratio of [inner mean]/[outer mean]
 *
 * inside, outside have to be allocated (size M * N)
 * mindist: determines radius of inner circle
 *
 * output will be written to bestd and bestdiff (single values NOT arrays)
 */
void
get_best_extension_mean(NMMatrix *m, const unsigned long idxi, const unsigned long idxj, const unsigned long mindist, const unsigned long maxdist, const unsigned long owidth, unsigned long* bestd, double* bestdiff, double *s1, double *s2, double *inside, double *outside);

/* ---------------------- get_best_extension_quantiles --------------------------
 * starting from (idxi, idxj) extends inner area and shifts outer
 * ring to get optimal extension for plateau like area
 * m should contain logarithmic values
 * compares quantiles for inner and outer circle (ring)
 *
 * inside, outside have to be allocated (size M * N)
 * pin, pout: percentage to get quantiles
 * mindist: determines radius of inner circle
 *
 * output will be written to bestd and bestdiff (single values NOT arrays)
 */
void
get_best_extension_quantiles(NMMatrix *m, const unsigned long idxi, const unsigned long idxj, const unsigned long mindist, const unsigned long maxdist, const unsigned long owidth, const double pin, const double pout, unsigned long* bestd, double* bestdiff, double *s1, double *s2, double *inside, double *outside);


/* ---------------------- get_best_extension_minmean --------------------------
 * starting from (idxi, idxj) extends inner area and shifts outer
 * ring to get optimal extension for plateau like area
 * m should contain non-logarithmic values
 * compares minimum area vs. mean ring
 *
 * inside, outside have to be allocated (size M * N)
 * mindist: determines radius of inner circle
 *
 * output will be written to bestd and bestdiff (single values NOT arrays)
 */
void
get_best_extension_minmean(NMMatrix *m, const unsigned long idxi, const unsigned long idxj, const unsigned long mindist, const unsigned long maxdist, const unsigned long owidth, unsigned long* bestd, double* bestdiff, double *s1, double *s2, double *inside, double *outside);


/* ---------------------- get_k_distance_ring -------------------------
 * returns a vector which contains all elements in a ring (squaure)
 * around element (i,j) which are separated by k-1 elements from (i,j)
 * or surrounding (i,j) in a distance of k
 * fills array elements which has to be allocated sufficiently
 *
 * returns number of elements in k distance ring
 */
unsigned long
get_k_distance_ring(NMMatrix *m, const unsigned long k, const unsigned long i, const unsigned long j, double *elements);

/* ---------------------- convert2log10_mat ----------------------------
 *
 * converts all alues of a matrix to log10 
 *
 */
void
convert2log10_mat(NMMatrix *m);

/* ---------------------- convert2prob_mat ----------------------------
 *
 * converts all ddG values of a matrix to probabilities
 *
 */
void
convert2prob_mat(NMMatrix *m, const double temp);


/* ---------------------- select_starting_points ----------------------------
 * determines starting points to search for plateau like area
 * w: working array will be overwritten
 * p: percentage (0-1) to determine quantile value
 * selected points will be written to ids_i and ids_j, i.e. entries which are
 * larger or equal to quantile values
 * 
 * returns number of selected elements
 */
unsigned long
select_starting_points(NMMatrix *m, double *w, unsigned long *ids_i, unsigned long *ids_j, const double p);

/* ---------------------- get_largest_id_area -------------------------
 * 
 * returns largest area where all entries have the given id value
 * returns size of area = number of elements
 */
unsigned long
get_largest_id_area(NMINTMatrix *m, const unsigned long id, const unsigned long i, const unsigned long j, const unsigned long max_k, unsigned long *radius);

#endif
