/* disjoint.h
 *
 * contains disjoint set operations using parent, rank and size array
 *
 * based on Cormen Introduction to Algorithms ...
 *
 *    Copyright (C) 2014  Nikolai Hecker
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef PLATEAU_DISJOINT_H
#define PLATEAU_DISJOINT_H

/* --------------------- make_set -------------------
 *
 * creates a new set
 *
 * arrays have to allocated
 */
void
make_set(const unsigned long id, unsigned long *parent, unsigned long *rank, unsigned long *size);


/* --------------------- find_set -------------------
 *
 * finds set
 *
 * arrays have to allocated
 */
unsigned long
find_set(const unsigned long id, unsigned long *parent);


/* --------------------- link_sets -------------------
 *
 * links two sets
 *
 * arrays have to allocated
 */
void
link_sets(const unsigned long id_a, const unsigned long id_b, unsigned long *parent, unsigned long *rank, unsigned long *size);


/* --------------------- union_sets -------------------
 *
 * combines two sets
 * arrays have to allocated
 *
 * returns 1 if sets were joined and 0 otherwise (already same set)
 */
int
union_sets(const unsigned long id_a, const unsigned long id_b, unsigned long *parent, unsigned long *rank, unsigned long *size);
#endif
