/* datatypes.h
 *
 * contains custom data type definitions
 *
 */
#ifndef RNACOP_PLATEAU_DATATYPES_H
#define RNACOP_PLATEAU_DATATYPES_H

/* N X M matrix definition
 */
typedef struct
{
	double **e; /*row index: pointer to matrix entries */
	double *entries; 
	size_t nrows;
	size_t ncols;
} NMMatrix;


/* N X M integer matrix definition
 */
typedef struct
{
	double **e; /*row index: pointer to matrix entries */
	double *entries; 
	size_t nrows;
	size_t ncols;
} NMINTMatrix;


/* a sortable struct with two indexes
 */
typedef struct
{
  unsigned long pid;
  unsigned long id;
  unsigned long i;
  unsigned long j;
  double v;
} TWOIDDbl;

#endif
