/*  header for N X M matrices
 */
#ifndef NMMATRIX_H
#define NMMATRIX_H

/* ------------------- nmm_init -------------------------------
 * allocates mem for N X M matrix and initializes matrix
 */
NMMatrix*
nmm_init(const size_t nrows, const size_t ncols);

/* ---- nmm_free -----
 * frees mem from 
 * matrix
 */
void
nmm_free(NMMatrix *mat);

/* ------- nmm_zero --------
 * fills N X M matrix with 0s
 */
void
nmm_zero(NMMatrix *mat);

/* ------- nmint_fill --------
 * fills N X M matrix with 0s
 */
void
nmintm_fill(NMINTMatrix *mat, const unsigned long val);

/* ------- nmintm_fill_radius --------
 * fills N X M matrix with 0s
 */
void
nmintm_fill_radius(NMINTMatrix *mat, const unsigned long i, const unsigned long j, const unsigned long radius, const unsigned long val);

/* ---- nmint_free -----
 * frees mem from 
 * matrix
 */
void
nmintm_free(NMINTMatrix *mat);

/* ------------------- nmint_init -------------------------------
 * allocates mem for N X M matrix and initializes matrix
 */
NMINTMatrix*
nmintm_init(const size_t nrows, const size_t ncols);

#endif
