#!/usr/bin/env perl

use Getopt::Long;
$path= $ENV{CMfinder};
$do_ranking= 1;
$do_weight = 0;
$dir = ".";
GetOptions(
	   "dir=s" => \$dir,
	   "weight" => \$do_weight,
	   "rank" => \$do_ranking,
);
$file_pattern = shift @ARGV;
$out_file = shift @ARGV;
opendir(DIR, $dir) || die "can't open dir $dir";
@files =grep /$file_pattern/, readdir (DIR);
closedir(DIR);


sub score{
    %stat = @_;
    $score= sqrt (($stat{"Conserved_pos"} + 0.2) * $stat{"BP.Pr"}/$stat{"Seq_id"}) * $stat{"Num"};
     return $score;
}

%all_stat=();
@fields=();
foreach $f (@files){   
    $f = "$dir/$f";
    print STDERR "$f\n";
    #Get the features.    
    if ($do_weight){	
	$result = `$path/summarize -w $f`;
    }
    else{
	$result = `$path/summarize $f`;
    }
    #Invalid motif.
    next if ($result =~ /^\s*$/); 
    my %stat = $result=~ /\s*(\S+)=(\S+)\s*/g;
    if (scalar @fields==0){
	@fields = sort keys %stat;
	push @fields, "Rank_score";
    }
    $stat{"Rank_score"} = score(%stat);
    $all_stat{$f} = \%stat;
}

open OUT, ">$out_file" or die "Can't open $out_file for writing";
$is_header = 1;
foreach $f (sort {$all_stat{$b}->{"Rank_score"} <=> $all_stat{$a}->{"Rank_score"}} keys %all_stat){
    $stat = $all_stat{$f};
    if ($is_header){        
	print OUT "motif,", (join ",",  @fields);	    
	print OUT "\n";
	$is_header=0;
    }
    print OUT "$f";
    foreach $k (@fields){
	print OUT ",",$stat->{$k};
    }	
    print OUT "\n";
}
close OUT;


