#include "edit_cost.h"
#include <stdio.h>
#define GAP_SYMB '-'
#define is_gap(c) (c==GAP_SYMB || c == '_' || c== '-'|| c== '.')


char PairCodeVienna(char c1, char c2) 
{  
  /* Hairpin */
  if ( is_gap(c1)) 
    return c2;
  
  if ( is_gap(c2) )
    return c1;
   
  if ( c1 == 'G' && c2 == 'C' ) return 'R';
  if ( c1 == 'C' && c2 == 'G' ) return 'S';
  if ( c1 == 'A' && c2 == 'U' ) return 'V';
  if ( c1 == 'U' && c2 == 'A' ) return 'W';
  if ( c1 == 'G' && c2 == 'U' ) return 'J';
  if ( c1 == 'U' && c2 == 'G' ) return 'K';
  return 8; 
}


/*---------------------------------------------------------------------------*/

void encode( int type, char* label)
{
    int   i, l;

    l = 0;
    for (i = 0; i < type; i++) {
        while (coding[l] != sep && coding[l]) l++;
        l++;
    }

    for (i = 0; coding[l+i] != sep; i++) {
        if (coding[l+i] == '\0') break;
        label[i] = coding[l+i];
    }
    label[i] = '\0';
}




int decode(char *id)
{
    int   n, quit, i;
    char  label[100], *code;

    n = 0;

    quit = 0;
    code = coding;

    while (!quit) {
        for (i = 0; code[i] != sep; i++) {
            if (code[i] == '\0') {
                quit = 1;
                break;
            }
            label[i] = code[i];
        }
        label[i] = '\0';
        if (strcmp(id, label) == 0) return (n);
        code += (i+1);
        n++;
    }

    fprintf(stderr,"Syntax error: node identifier \"%s\" not found "
		   "in coding string \"%s\"\n", id, coding);
    fprintf(stderr,"Exiting...");
    exit(0);
}
