#ifndef EDIT_COST_H
#define EDIT_COST_H

/*   

cost.h   ::  global variables for Edit Costs
             included by treedist.c and stringdist.c

*/
#define PRIVATE static

PRIVATE char   sep = ':';

PRIVATE char  *coding = "Null:A:C:G:U:R:S:V:W:J:K:N:";


#define  INF 10000  /* infinity */  


typedef int CostMatrix[12][12];

PRIVATE CostMatrix *EditCost;  /* will point to UsualCost or ShapiroCost */

PRIVATE CostMatrix  UsualCost= 
{
/*    Null, A,   C,   G,   T,  GC, CG,   AU,  UA,  GU,  UG, other     */

   {   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2},   /* Null  replaced */
   {   2,   0,   2,   2,   2, INF, INF, INF, INF, INF, INF, INF},   /* A     replaced */
   {   2,   2,   0,   2,   2, INF, INF, INF, INF, INF, INF, INF},   /* C     replaced */
   {   2,   2,   2,   0,   2, INF, INF, INF, INF, INF, INF, INF},   /* G     replaced */
   {   2,   2,   2,   2,   0, INF, INF, INF, INF, INF, INF, INF},   /* T     replaced */
   {   2, INF, INF, INF, INF,   0,   1,   1,   1,   1,   1,   1},   /* GC    replaced */
   {   2, INF, INF, INF, INF,   1,   0,   1,   1,   1,   1,   1},   /* CG    replaced */
   {   2, INF, INF, INF, INF,   1,   1,   0,   1,   1,   1,   1},   /* AU    replaced */
   {   2, INF, INF, INF, INF,   1,   1,   1,   0,   1,   1,   1},   /* UA    replaced */
   {   2, INF, INF, INF, INF,   1,   1,   1,   1,   0,   1,   1},   /* GU    replaced */
   {   2, INF, INF, INF, INF,   1,   1,   1,   1,   1,   0,   1},   /* UG    replaced */
   {   2, INF, INF, INF, INF,   1,   1,   1,   1,   1,   1,   0}   /* other replaced */
};


void encode(int code, char* s);
int decode(char* c);
char PairCodeVienna(char c1, char c2);

#endif
