/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.gui.alignment;

import dk.kvl.controller.AlignmentController;
import dk.kvl.gui.alignment.table.AlignmentDataModel;
import dk.kvl.gui.alignment.table.AlignmentTable;
import dk.kvl.gui.alignment.table.TitleTable;
import dk.kvl.gui.components.TwoTablePanel;
import dk.kvl.gui.properties.AlignmentProperties;
import dk.kvl.tools.StringTools;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelListener;

public class AlignmentPanel
extends JPanel
implements ListSelectionListener,
ChangeListener {
    private AlignmentTable sequenceTable = null;
    private AlignmentTable sequenceTable2 = null;
    private AlignmentTable sequenceTable3 = null;
    private TitleTable nameTable = null;
    private TitleTable nameTable2 = null;
    private TitleTable nameTable3 = null;
    private TwoTablePanel tableView = null;
    private TwoTablePanel tableView2 = null;
    private TwoTablePanel tableView3 = null;
    private JPanel sequencePanel = null;
    private AlignmentProperties properties = null;
    private AlignmentController alignmentController = null;
    private String alignmentName = null;
    private JPanel splitView = null;
    private JSplitPane splitPane = null;
    private Vector sequenceSelectionListeners = new Vector();
    private boolean horizontalSplit;
    private boolean split = false;
    private boolean selectionMode;
    private boolean trace = true;
    private int operationMode;
    private final int unsplitIndex = 1;
    private final int splitIndex = 2;
    private boolean mouse;
    private Vector listeners = new Vector();
    private String wDir = "";

    public AlignmentPanel(AlignmentController alignCtrl, AlignmentProperties properties, String name) throws Exception {
        super(new CardLayout());
        this.properties = properties;
        this.alignmentName = name;
        this.alignmentController = alignCtrl;
        this.createView(name);
        this.updateGrid();
        this.nameTable.getSelectionModel().addListSelectionListener(this);
    }

    public void stateChanged(ChangeEvent ce) {
        if (this.trace && this.tableView2 != null && !this.mouse && ce.getSource() instanceof JViewport) {
            JViewport port = (JViewport)ce.getSource();
            Point view = port.getViewPosition();
            JViewport t2 = this.tableView2.getViewport();
            JViewport t3 = this.tableView3.getViewport();
            Point point2 = new Point();
            point2.setLocation(t2.getViewPosition().getX(), view.getY());
            Point point3 = new Point();
            point3.setLocation(t3.getViewPosition().getX(), view.getY());
            t2.setViewPosition(point2);
            t3.setViewPosition(point3);
        }
        this.mouse = false;
    }

    public String getAlignmentName() {
        return this.alignmentName;
    }

    public String getWdir() {
        return this.properties.getLastPath();
    }

    public boolean horizontalSplit() {
        return this.horizontalSplit;
    }

    public void setSplitAlign(boolean horizontalSplit) {
        this.horizontalSplit = horizontalSplit;
        if (horizontalSplit) {
            this.splitPane.setOrientation(0);
        } else {
            this.splitPane.setOrientation(1);
        }
        this.setVisible(true);
        this.splitPane.setDividerLocation(0.5);
    }

    protected void createView(String name) throws Exception {
        this.createTables(name);
        this.tableView = new TwoTablePanel(this.nameTable, this.sequenceTable, this.properties);
        this.add((Component)this.tableView, "unsplit");
    }

    public void createTables(String name) {
        this.nameTable = new TitleTable(this.alignmentController, name, this.properties);
        this.sequenceTable = new AlignmentTable(new AlignmentDataModel(this.alignmentController, name, this.nameTable), this.properties, this.alignmentController.getMainAlignment(), this);
        this.sequenceTable.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (!AlignmentPanel.this.selectionMode && AlignmentPanel.this.alignmentController.getMainAlignment().getNumberOfPairingMasks() > 0) {
                    int[] rows = AlignmentPanel.this.sequenceTable.getSelectedRows();
                    int[] cols = AlignmentPanel.this.sequenceTable.getSelectedColumns();
                    for (int i = 0; i < rows.length; ++i) {
                        for (int j = 0; j < cols.length; ++j) {
                            int row = rows[i];
                            int col = cols[j];
                            AlignmentPanel.this.sequenceTable.addRowSelectionInterval(row, row);
                            int pair = AlignmentPanel.this.getPairing(row, col);
                            if (pair <= -1) continue;
                            AlignmentPanel.this.sequenceTable.addColumnSelectionInterval(pair, pair);
                        }
                    }
                    AlignmentPanel.this.mouse = true;
                }
            }

            public void mousePressed(MouseEvent e) {
                if (AlignmentPanel.this.isSplit() && AlignmentPanel.this.sequenceTable3 != null && !e.isControlDown()) {
                    AlignmentPanel.this.sequenceTable3.clearSelection();
                }
            }
        });
    }

    public void addColumnModelListener(TableColumnModelListener listener) {
        this.sequenceTable.getColumnModel().addColumnModelListener(listener);
    }

    public int[] getSelectedColumns() {
        if (this.isSplit()) {
            return StringTools.combineSortedArrays(this.getLeftSelectedColumns(), this.getRightSelectedColumns());
        }
        return this.sequenceTable.getSelectedColumns();
    }

    protected int[] getLeftSelectedColumns() {
        if (this.isSplit()) {
            return this.sequenceTable2.getSelectedColumns();
        }
        return new int[0];
    }

    protected int[] getRightSelectedColumns() {
        if (this.isSplit()) {
            return this.sequenceTable3.getSelectedColumns();
        }
        return new int[0];
    }

    public int[] getSelectedRows() {
        if (this.isSplit()) {
            return StringTools.combineSortedArrays(this.getLeftSelectedRows(), this.getRightSelectedRows());
        }
        return this.sequenceTable.getSelectedRows();
    }

    public int[] getSelectedNameRows() {
        if (this.isSplit()) {
            return this.nameTable2.getSelectedRows();
        }
        return this.nameTable.getSelectedRows();
    }

    protected int[] getLeftSelectedRows() {
        if (this.isSplit()) {
            return this.sequenceTable2.getSelectedRows();
        }
        return new int[0];
    }

    protected int[] getRightSelectedRows() {
        if (this.isSplit()) {
            return this.sequenceTable3.getSelectedRows();
        }
        return new int[0];
    }

    public String getSequenceName(int row) {
        if (row >= 0 && row < this.sequenceTable.getRowCount()) {
            return this.nameTable.getSequenceName(row);
        }
        return null;
    }

    public String[] getSequenceNames(int[] rows) {
        String[] names = new String[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            names[i] = this.getSequenceName(rows[i]);
        }
        return names;
    }

    public int getColumnNumber(int col) {
        return Integer.parseInt(this.sequenceTable.getColumnName(col));
    }

    public void clearSelections() {
        this.nameTable.clearSelection();
        this.sequenceTable.clearSelection();
        if (this.nameTable2 != null) {
            this.nameTable2.clearSelection();
            this.sequenceTable2.clearSelection();
            this.nameTable3.clearSelection();
            this.sequenceTable3.clearSelection();
        }
    }

    public TwoTablePanel getSplitActionListener() {
        return this.tableView;
    }

    public void split() {
        if (!this.isSplit()) {
            Point p = this.tableView.getViewport().getViewPosition();
            if (this.splitView == null) {
                this.createSplitViewComponent();
            }
            this.operationMode(this.operationMode);
            this.selectionMode(this.selectionMode);
            this.clearSelections();
            this.split = true;
            this.tableView2.getViewport().setViewPosition(p);
            ((CardLayout)this.getLayout()).show(this, "split");
            this.splitPane.setDividerLocation(0.5);
        }
    }

    public void unsplit() {
        if (this.isSplit()) {
            ((CardLayout)this.getLayout()).show(this, "unsplit");
            this.clearSelections();
            this.split = false;
        }
    }

    public boolean isSplit() {
        return this.split;
    }

    public boolean isPrimarySelection() {
        return this.selectionMode;
    }

    public String[] getSelectedSequenceNames() {
        int[] rows = null;
        rows = this.isSplit() ? StringTools.combineSortedArrays(this.getLeftSelectedRows(), this.getRightSelectedRows()) : this.sequenceTable.getSelectedRows();
        String[] names = this.getSequenceNames(rows);
        return names;
    }

    public Collection getSelectedNames() {
        if (this.isSplit()) {
            return new Vector();
        }
        return this.nameTable.getSelectedNames();
    }

    protected Collection getLeftSelectedNames() {
        if (this.isSplit()) {
            return this.nameTable2.getSelectedNames();
        }
        return null;
    }

    protected Collection getRightSelectedNames() {
        if (this.isSplit()) {
            return this.nameTable3.getSelectedNames();
        }
        return null;
    }

    protected void createSplitViewComponent() {
        try {
            if (this.splitView == null) {
                this.nameTable2 = new TitleTable(this.alignmentController, this.alignmentName, this.properties);
                this.nameTable3 = new TitleTable(this.alignmentController, this.alignmentName, this.properties);
                this.sequenceTable2 = new AlignmentTable(new AlignmentDataModel(this.alignmentController, this.alignmentName, this.nameTable), this.properties, this.alignmentController.getMainAlignment(), this);
                this.sequenceTable3 = new AlignmentTable(new AlignmentDataModel(this.alignmentController, this.alignmentName, this.nameTable), this.properties, this.alignmentController.getMainAlignment(), this);
                this.splitView = new JPanel(new BorderLayout());
                this.tableView2 = new TwoTablePanel(this.nameTable2, this.sequenceTable2, this.properties);
                this.tableView3 = new TwoTablePanel(this.nameTable3, this.sequenceTable3, this.properties);
                this.splitPane = this.horizontalSplit() ? new JSplitPane(0, this.tableView2, this.tableView3) : new JSplitPane(1, this.tableView2, this.tableView3);
                this.splitView.add("Center", this.splitPane);
                this.add((Component)this.splitView, "split");
                this.sequenceTable2.addMouseListener(new MouseAdapter(){

                    public void mouseReleased(MouseEvent e) {
                        if (!AlignmentPanel.this.selectionMode && AlignmentPanel.this.isSplit()) {
                            int[] rows = AlignmentPanel.this.sequenceTable2.getSelectedRows();
                            int[] cols = AlignmentPanel.this.sequenceTable2.getSelectedColumns();
                            for (int i = 0; i < rows.length; ++i) {
                                for (int j = 0; j < cols.length; ++j) {
                                    int row = rows[i];
                                    int col = cols[j];
                                    AlignmentPanel.this.sequenceTable3.addRowSelectionInterval(row, row);
                                    int pair = AlignmentPanel.this.getPairing(row, col);
                                    if (pair <= -1) continue;
                                    AlignmentPanel.this.sequenceTable3.addColumnSelectionInterval(pair, pair);
                                }
                            }
                            AlignmentPanel.this.mouse = true;
                            AlignmentPanel.this.centerTable(AlignmentPanel.this.getPairing(AlignmentPanel.this.sequenceTable2.getSelectedRow(), AlignmentPanel.this.sequenceTable2.getSelectedColumn()), new Double(AlignmentPanel.this.tableView2.getViewport().getViewPosition().getY()).intValue());
                        }
                    }

                    public void mousePressed(MouseEvent e) {
                        if (AlignmentPanel.this.isSplit() && AlignmentPanel.this.sequenceTable3 != null && !e.isControlDown()) {
                            AlignmentPanel.this.sequenceTable3.clearSelection();
                        }
                    }
                });
                this.sequenceTable3.addMouseListener(new MouseAdapter(){

                    public void mouseReleased(MouseEvent e) {
                        if (AlignmentPanel.this.isSplit() && !AlignmentPanel.this.selectionMode) {
                            int[] rows = AlignmentPanel.this.sequenceTable3.getSelectedRows();
                            int[] cols = AlignmentPanel.this.sequenceTable3.getSelectedColumns();
                            for (int i = 0; i < rows.length; ++i) {
                                for (int j = 0; j < cols.length; ++j) {
                                    int row = rows[i];
                                    int col = cols[j];
                                    AlignmentPanel.this.sequenceTable2.addRowSelectionInterval(row, row);
                                    int pair = AlignmentPanel.this.getPairing(row, col);
                                    if (pair == -1) continue;
                                    AlignmentPanel.this.sequenceTable2.addColumnSelectionInterval(pair, pair);
                                }
                            }
                            AlignmentPanel.this.mouse = true;
                            AlignmentPanel.this.centerLeftTable(AlignmentPanel.this.getPairing(AlignmentPanel.this.sequenceTable3.getSelectedRow(), AlignmentPanel.this.sequenceTable3.getSelectedColumn()), new Double(AlignmentPanel.this.tableView3.getViewport().getViewPosition().getY()).intValue());
                        }
                    }

                    public void mousePressed(MouseEvent e) {
                        if (AlignmentPanel.this.isSplit() && AlignmentPanel.this.sequenceTable2 != null && !e.isControlDown()) {
                            AlignmentPanel.this.sequenceTable2.clearSelection();
                        }
                    }
                });
                this.tableView2.getViewport().addChangeListener(this);
                this.tableView3.getViewport().addChangeListener(this);
                this.tableView2.addListSelectionListener(this);
                this.tableView3.addListSelectionListener(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void centerTable(int column, int row) {
        if (this.isSplit()) {
            this.tableView3.centerTable(column, row);
        } else {
            this.tableView.centerTable(column, row);
        }
    }

    public void centerLeftTable(int column, int row) {
        if (this.isSplit()) {
            this.tableView2.centerTable(column, row);
        }
    }

    public void addSequenceSelectionListener(ActionListener listener) {
        this.sequenceSelectionListeners.add(listener);
    }

    public void removeSequenceSelectionListener(ActionListener listener) {
        this.sequenceSelectionListeners.remove(listener);
    }

    public void valueChanged(ListSelectionEvent lse) {
        Collection selected = null;
        if (selected != null && selected.size() > 0) {
            this.fireActionEvent((String)selected.toArray()[0]);
        }
    }

    public void fireActionEvent(String seqName) {
        ActionEvent ae = new ActionEvent(this, 0, seqName);
        for (int i = 0; i < this.sequenceSelectionListeners.size(); ++i) {
            ((ActionListener)this.sequenceSelectionListeners.get(i)).actionPerformed(ae);
        }
    }

    public void setTraceEnabled(boolean value) {
        this.trace = value;
        if (this.tableView2 != null) {
            this.tableView2.setTraceEnabled(value);
            this.tableView3.setTraceEnabled(value);
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.tableView.addListSelectionListener(listener);
        this.listeners.add(listener);
        if (this.tableView2 != null) {
            this.tableView2.addListSelectionListener(listener);
            this.tableView3.addListSelectionListener(listener);
        }
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.tableView.removeListSelectionListener(listener);
        this.listeners.remove(listener);
        if (this.tableView2 != null) {
            this.tableView2.removeListSelectionListener(listener);
            this.tableView3.removeListSelectionListener(listener);
        }
    }

    public void toggleSplit() {
        if (this.isSplit()) {
            if (this.splitPane.getOrientation() == 0) {
                this.splitPane.setOrientation(1);
            } else {
                this.splitPane.setOrientation(0);
            }
        }
    }

    public void columnInfo(String column, boolean enabled) {
    }

    public void splitMode(boolean mode) {
        this.horizontalSplit = mode;
        if (this.isSplit()) {
            if (this.horizontalSplit) {
                this.splitPane.setOrientation(0);
            } else {
                this.splitPane.setOrientation(1);
            }
            this.splitPane.setDividerLocation(0.5);
        }
        this.setVisible(true);
    }

    public boolean getSplitMode() {
        return this.horizontalSplit;
    }

    public void selectionMode(boolean mode) {
        if (this.sequenceTable != null) {
            this.selectionMode = mode;
            this.sequenceTable.clearSelection();
            if (this.sequenceTable3 != null) {
                if (mode) {
                    this.sequenceTable3.clearSelection();
                    this.sequenceTable2.repaint();
                } else if (this.alignmentController.getMainAlignment().getNumberOfPairingMasks() > 0) {
                    this.sequenceTable2.repaint();
                    int[] rows = this.sequenceTable2.getSelectedRows();
                    int[] cols = this.sequenceTable2.getSelectedColumns();
                    for (int i = 0; i < rows.length; ++i) {
                        for (int j = 0; j < cols.length; ++j) {
                            int row = rows[i];
                            int col = cols[j];
                            this.sequenceTable3.addRowSelectionInterval(row, row);
                            int pair = this.getPairing(row, col);
                            this.sequenceTable3.addColumnSelectionInterval(pair, pair);
                        }
                    }
                    this.mouse = true;
                    this.centerTable(this.getPairing(this.sequenceTable2.getSelectedRow(), this.sequenceTable2.getSelectedColumn()), new Double(this.tableView2.getViewport().getViewPosition().getY()).intValue());
                }
            }
        }
    }

    public int getPairing(int row, int col) {
        int pair = this.alignmentController.getPairing(this.getSequenceName(row), col);
        return pair;
    }

    public AlignmentController getController() {
        return this.alignmentController;
    }

    public void operationMode(int mode) {
        this.operationMode = mode;
        if (this.isSplit() && this.sequenceTable2 != null && this.sequenceTable3 != null && this.alignmentController.getMainAlignment().getNumberOfPairingMasks() > 0) {
            this.sequenceTable2.repaint();
            this.mouse = true;
            this.centerTable(this.sequenceTable3.getSelectedColumn(), this.sequenceTable3.getSelectedRow());
        }
    }

    public int getOperationMode() {
        return this.operationMode;
    }

    public boolean getSelectionMode() {
        return this.selectionMode;
    }

    public JTable getTable() {
        return this.sequenceTable;
    }

    public JTable getTable2() {
        return this.sequenceTable2;
    }

    public JTable getTable3() {
        return this.sequenceTable3;
    }

    public void updateCellSize() {
        this.nameTable.setFont(this.properties.getTableFont());
        if (this.nameTable2 != null) {
            this.nameTable2.setFont(this.properties.getTableFont());
            this.nameTable3.setFont(this.properties.getTableFont());
        }
        this.tableView.updateCellSize();
        if (this.tableView2 != null) {
            this.tableView2.updateCellSize();
            this.tableView3.updateCellSize();
        }
    }

    public void updateGrid() {
        this.tableView.updateGrid();
        if (this.tableView2 != null) {
            this.tableView2.updateGrid();
            this.tableView3.updateGrid();
        }
    }

    public TwoTablePanel getTableView() {
        return this.tableView;
    }

    public TwoTablePanel getTableView2() {
        return this.tableView2;
    }

    public TwoTablePanel getTableView3() {
        return this.tableView3;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public AlignmentController getAlignmentController() {
        return this.alignmentController;
    }

    public void verticalCenter(int sequenceNumber) {
        if (sequenceNumber > 0 && sequenceNumber <= this.alignmentController.getNumberOfSequences()) {
            if (this.isSplit()) {
                this.tableView2.verticalCenter((int)this.tableView2.getViewport().getViewPosition().getX(), sequenceNumber);
            } else {
                this.tableView.verticalCenter((int)this.tableView.getViewport().getViewPosition().getX(), sequenceNumber);
            }
        }
    }

    public void centerCell(int col, int row) {
        if (this.isSplit()) {
            this.tableView2.centerCell(col, row);
        } else {
            this.tableView.centerCell(col, row);
        }
    }
}

