/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.gui.alignment.table;

import dk.kvl.alignmenttools.Alignment;
import dk.kvl.gui.alignment.table.AlignmentBorder;
import dk.kvl.gui.properties.AlignmentProperties;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class SmallHeader
extends JLabel
implements TableCellRenderer {
    private Alignment alignment;
    private AlignmentProperties properties;

    public SmallHeader(Alignment align, AlignmentProperties prop) {
        this.setOpaque(true);
        if (this.properties == null) {
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        } else {
            try {
                this.setBorder(new AlignmentBorder(this.properties));
            }
            catch (Exception e) {
                this.setBorder(new EmptyBorder(1, 1, 1, 1));
            }
        }
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(0);
        this.properties = prop;
        this.setFont(this.properties.getTableFont());
        this.alignment = align;
    }

    public Component getTableCellRendererComponent(JTable table, Object title, boolean isSelected, boolean hasFocus, int row, int column) {
        String txt = "";
        String pair = "<br>&nbsp;";
        this.setFont(this.properties.getTableFont());
        table.setBackground(this.properties.getBackground());
        table.setForeground(this.properties.getSequenceColor());
        if (row == -1) {
            if (table.getColumnCount() == 1) {
                txt = "&nbsp;<br>&nbsp;";
                if (this.alignment.getPairingMask() != null) {
                    txt = txt + "<br>&nbsp";
                }
            } else {
                if ((column + 1) % 5 == 0) {
                    pair = "<br>|";
                }
                if (column == 0) {
                    txt = " 1" + pair;
                } else {
                    int col = column + 1;
                    String s = null;
                    if ((col + 1) % 10 == 0) {
                        s = String.valueOf(col + 1);
                        txt = " " + s.substring(s.length() - 2, s.length() - 1) + pair;
                    } else if ((col + 2) % 10 == 0 && col + 2 >= 100) {
                        s = String.valueOf(col + 2);
                        txt = " " + s.substring(s.length() - 3, s.length() - 2) + pair;
                    } else if ((col + 3) % 10 == 0 && col + 3 >= 1000) {
                        s = String.valueOf(col + 3);
                        txt = " " + s.substring(s.length() - 4, s.length() - 3) + pair;
                    } else if ((col + 4) % 10 == 0 && col + 4 >= 10000) {
                        s = String.valueOf(col + 4);
                        txt = " " + s.substring(s.length() - 5, s.length() - 4) + pair;
                    } else if (col % 10 == 0) {
                        s = String.valueOf(col);
                        txt = " " + s.substring(s.length() - 1, s.length()) + pair;
                    } else {
                        txt = pair;
                    }
                }
                if (this.alignment.getPairingMask() != null) {
                    String symbol = String.valueOf(this.alignment.getPairingMask().getSymbolAt(column));
                    if (symbol.equals("<")) {
                        symbol = "&lt;";
                    }
                    txt = txt + "<br> " + symbol;
                }
            }
        }
        this.setText("<html>" + txt + "</html>");
        return this;
    }
}

