/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.gui.components;

import dk.kvl.gui.properties.AlignmentProperties;
import dk.kvl.tools.History;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;

public class HistoryTreeRenderer
extends JLabel
implements TreeCellRenderer {
    private String fileName;
    private History history;
    private boolean isShownParent;
    private String txt;
    private int changeColor;
    private DefaultMutableTreeNode root;
    private AlignmentProperties properties;

    public HistoryTreeRenderer(String fileName, History history, DefaultMutableTreeNode root, AlignmentProperties properties) {
        this.fileName = fileName;
        this.history = history;
        this.root = root;
        this.properties = properties;
        this.setOpaque(true);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.txt = value.toString();
        this.setFont(this.properties.getTableFont());
        this.setText(this.txt);
        if (!this.txt.equals("Files in project")) {
            this.setFont(this.getFont().deriveFont(2));
        } else {
            this.setFont(this.getFont().deriveFont(0));
        }
        this.isShownParent = this.txt.equals(this.fileName);
        Enumeration<TreeNode> e = this.root.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            Enumeration<TreeNode> enumeration = node.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumeration.nextElement();
                if (!child.equals((DefaultMutableTreeNode)value)) continue;
                int childIndex = node.getIndex(child);
                int hisIndex = 0;
                hisIndex = this.history.getUndone() ? this.history.getPosition() : this.history.getIndex();
                if (childIndex < hisIndex) {
                    this.setFont(this.getFont().deriveFont(0));
                    continue;
                }
                if (childIndex > hisIndex) {
                    this.setFont(this.getFont().deriveFont(2));
                    continue;
                }
                if (childIndex != hisIndex) continue;
                if (this.history.getUndone()) {
                    this.setFont(this.getFont().deriveFont(2));
                    continue;
                }
                this.setFont(this.getFont().deriveFont(0));
            }
        }
        if (((DefaultMutableTreeNode)value).getDepth() == 1) {
            this.setFont(this.getFont().deriveFont(0));
        }
        this.setIcon(null);
        return this;
    }

    public void paint(Graphics g) {
        Color bColor = this.isShownParent ? Color.lightGray : Color.white;
        g.setColor(bColor);
        g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        this.changeColor = 0;
        super.paint(g);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setHistory(History history) {
        this.history = history;
    }
}

