/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.gui.components;

import dk.kvl.gui.alignment.table.AlignmentTable;
import dk.kvl.gui.alignment.table.TitleTable;
import dk.kvl.gui.properties.AlignmentProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TwoTablePanel
extends JPanel
implements ChangeListener,
ListSelectionListener {
    private JScrollPane mainScroll = null;
    private JScrollPane nameScroll = null;
    private AlignmentTable mainTable = null;
    private TitleTable nameTable = null;
    private Vector changeListeners = new Vector();
    private boolean traceEnabled = true;
    private JSplitPane split = null;
    private AlignmentProperties properties = null;

    public TwoTablePanel(TitleTable nameTable, AlignmentTable mainTable, AlignmentProperties prop) throws Exception {
        super(new BorderLayout());
        this.setDoubleBuffered(true);
        this.properties = prop;
        if (nameTable.getRowCount() != nameTable.getRowCount()) {
            throw new Exception("The number of rows must be equal");
        }
        if (nameTable.getColumnCount() != 1) {
            throw new Exception("The nameTable may only contain one column");
        }
        this.mainTable = mainTable;
        this.nameTable = nameTable;
        nameTable.setFont(this.properties.getTableFont());
        this.mainScroll = new JScrollPane(mainTable);
        this.mainScroll.setDoubleBuffered(true);
        this.mainScroll.getViewport().addChangeListener(this);
        this.nameScroll = new JScrollPane(nameTable, 21, 32);
        mainTable.setCellSelectionEnabled(true);
        nameTable.setCellSelectionEnabled(true);
        mainTable.setAutoResizeMode(0);
        nameTable.setAutoResizeMode(0);
        this.updateGrid();
        this.split = new JSplitPane(1, this.nameScroll, this.mainScroll);
        this.split.setDividerLocation(mainTable.getColumnModel().getColumn(0).getWidth());
        this.add((Component)this.split, "Center");
        this.updateCellSize();
    }

    public void setDividerLocation(double pos) {
        this.split.setDividerLocation(pos);
    }

    public void stateChanged(ChangeEvent ce) {
        if (ce.getSource() instanceof Integer) {
            int y = (Integer)ce.getSource();
            int x = (int)this.nameScroll.getViewport().getViewPosition().getX();
            this.nameScroll.getViewport().setViewPosition(new Point(x, y));
            x = (int)this.mainScroll.getViewport().getViewPosition().getX();
            this.mainScroll.getViewport().setViewPosition(new Point(x, y));
        } else {
            int y = (int)this.mainScroll.getViewport().getViewPosition().getY();
            int x = (int)this.nameScroll.getViewport().getViewPosition().getX();
            this.nameScroll.getViewport().setViewPosition(new Point(x, y));
        }
    }

    public void centerTable(int column, int row) {
        int posY = row;
        int compHeight = (int)this.mainTable.getSize().getHeight();
        int compWidth = (int)this.mainTable.getSize().getWidth();
        Dimension viewDim = this.mainScroll.getViewport().getExtentSize();
        int hStep = compWidth / this.mainTable.getColumnCount();
        int posX = column * hStep - (int)viewDim.getWidth() / 2;
        if (posX < 0) {
            posX = 0;
        }
        if (posX > compWidth - viewDim.width) {
            posX = compWidth - viewDim.width;
        }
        this.mainScroll.getViewport().setViewPosition(new Point(posX, posY));
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void setTraceEnabled(boolean value) {
        this.traceEnabled = value;
        if (this.traceEnabled) {
            this.fireStateChangedEvent((int)this.mainScroll.getViewport().getViewPosition().getY());
        }
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void fireStateChangedEvent(int y) {
        ChangeEvent ce = new ChangeEvent(new Integer(y));
        this.stateChanged(ce);
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            ((ChangeListener)this.changeListeners.get(i)).stateChanged(ce);
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.mainTable.getColumnModel().getSelectionModel().addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.mainTable.getColumnModel().getSelectionModel().removeListSelectionListener(listener);
    }

    public void valueChanged(ListSelectionEvent lse) {
    }

    public JViewport getViewport() {
        return this.mainScroll.getViewport();
    }

    public void updateCellSize() {
        int cellHeight = this.mainTable.getPreferredCellHeight();
        int cellWidth = this.mainTable.getPreferredCellWidth();
        this.mainTable.setRowHeight(cellHeight);
        this.nameTable.setRowHeight(cellHeight);
        int padding = 5;
        int nameTableWidth = this.nameTable.getMaximumWidth() + 2 * padding;
        this.nameTable.getTableHeader().setSize(new Dimension(nameTableWidth, 2 * cellHeight));
        this.nameTable.getColumnModel().getColumn(0).setPreferredWidth(nameTableWidth);
        this.mainTable.getTableHeader().setSize(new Dimension((int)this.mainTable.getTableHeader().getSize().getWidth(), 2 * cellHeight));
        for (int i = 0; i < this.mainTable.getColumnCount(); ++i) {
            this.mainTable.getColumnModel().getColumn(i).setPreferredWidth(cellWidth);
            this.mainTable.getColumnModel().getColumn(i).setMinWidth(cellWidth);
        }
    }

    public void updateGrid() {
        this.mainTable.setShowGrid(this.properties.isGrid());
        this.nameTable.setShowGrid(this.properties.isGrid());
    }

    public void verticalCenter(int column, int row) {
        int posX = column;
        int compHeight = (int)this.mainTable.getSize().getHeight();
        int compWidth = (int)this.mainTable.getSize().getWidth();
        Dimension viewDim = this.mainScroll.getViewport().getExtentSize();
        int vStep = compHeight / this.mainTable.getRowCount();
        int posY = row * vStep - (int)viewDim.getHeight() / 2;
        if (posY < 0) {
            posY = 0;
        }
        if (posY > compHeight - viewDim.height) {
            posY = compHeight - viewDim.height;
        }
        this.mainScroll.getViewport().setViewPosition(new Point(posX, posY));
    }

    public void centerCell(int column, int row) {
        int posY = row;
        int posX = column;
        int compHeight = (int)this.mainTable.getSize().getHeight();
        int compWidth = (int)this.mainTable.getSize().getWidth();
        Dimension viewDim = this.mainScroll.getViewport().getExtentSize();
        int vStep = compHeight / this.mainTable.getRowCount();
        int hStep = compWidth / this.mainTable.getColumnCount();
        posY = row * vStep - (int)viewDim.getHeight() / 2;
        posX = column * hStep - (int)viewDim.getWidth() / 2;
        if (posY > compHeight - viewDim.height) {
            posY = compHeight - viewDim.height;
        }
        if (posX > compWidth - viewDim.width) {
            posX = compWidth - viewDim.width;
        }
        if (posY < 0 || (double)compHeight <= viewDim.getHeight()) {
            posY = 0;
        }
        if (posX < 0 || (double)compWidth <= viewDim.getWidth()) {
            posX = 0;
        }
        this.mainScroll.getViewport().setViewPosition(new Point(posX, posY));
    }
}

