/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.tools.history;

import dk.kvl.alignmenttools.Alignment;
import dk.kvl.sequencetools.Sequence;
import dk.kvl.tools.history.HistoryItem;

public class AddSequences
implements HistoryItem {
    private final Sequence[] sequences;

    public AddSequences(Sequence[] addedSequences) {
        this.sequences = addedSequences;
    }

    public void undo(Alignment alignment) {
        for (int i = 0; i < this.sequences.length; ++i) {
            alignment.removeSequence(this.sequences[i].getLabel());
        }
    }

    public void redo(Alignment alignment) {
        for (int i = 0; i < this.sequences.length; ++i) {
            Sequence seq = this.sequences[i];
            seq.setNumber(alignment.getNumberOfSequences() + 1);
            alignment.addSequence(seq);
        }
    }

    public String getLabel() {
        return "Sequences Added";
    }
}

