/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.tools.history;

import dk.kvl.alignmenttools.Alignment;
import dk.kvl.tools.IntArray;
import dk.kvl.tools.history.HistoryItem;

public class RemoveGaps
implements HistoryItem {
    private IntArray indexs;
    private char[] pairingmask;

    public RemoveGaps(IntArray indexs, char[] mask) {
        this.indexs = indexs;
        this.pairingmask = mask;
    }

    public void undo(Alignment alignment) {
        for (int i = this.indexs.getLength() - 1; i >= 0; --i) {
            alignment.addColumn(this.indexs.get(i), '-');
            alignment.getPairingMask().changeSymbol(this.pairingmask[i], this.indexs.get(i));
        }
    }

    public void redo(Alignment alignment) {
        for (int i = 0; i < this.indexs.getLength(); ++i) {
            alignment.removeColumn(this.indexs.get(i));
        }
    }

    public String getLabel() {
        return "Remove gaps";
    }
}

