/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.alignmenttools.io;

import dk.kvl.alignmenttools.Alignment;
import dk.kvl.alignmenttools.io.AlignmentReader;
import dk.kvl.sequencetools.PairingMask;
import dk.kvl.sequencetools.Sequence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ColReader
extends BufferedReader
implements AlignmentReader {
    private Alignment alignment = new Alignment();

    public ColReader(File fileName) throws FileNotFoundException {
        super(new FileReader(fileName));
        this.readHeader();
    }

    public ColReader(String fileName) throws FileNotFoundException {
        this(new File(fileName));
    }

    public void readHeader() {
        String line = null;
        StringBuffer fileHeader = new StringBuffer();
        try {
            line = this.readLine();
            if (line != null) {
                while (!line.startsWith("; ==========")) {
                    if (line.length() > 2) {
                        fileHeader.append(line.substring(2) + "\n");
                    } else {
                        fileHeader.append("\n");
                    }
                    line = this.readLine();
                }
                this.alignment.setHeader(fileHeader);
                this.readSequences(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readSequences(String line) {
        int number = 1;
        Pattern typePattern = Pattern.compile("^; *TYPE");
        Pattern pairingmaskPattern = Pattern.compile("[Pp][Aa][Ii][Rr][Ii][Nn][Gg][Mm][Aa][Ss][Kk]");
        Pattern colPattern = Pattern.compile("^; *[Cc][Oo][Ll]");
        Pattern entryPattern = Pattern.compile("^; *[Ee][Nn][Tt][Rr][Yy]");
        Pattern wordPattern = Pattern.compile("\\S+");
        Pattern numberPattern = Pattern.compile("\\d+");
        Pattern dnaPattern = Pattern.compile("[Dd][Nn][Aa]");
        Pattern rnaPattern = Pattern.compile("[Rr][Nn][Aa]");
        Pattern arbitraryPattern = Pattern.compile("[Aa][Rr][Bb][Ii][Tt][Rr][Aa][Rr][Yy]");
        Pattern treePattern = Pattern.compile("[Tt][Rr][Ee][Ee]");
        boolean counter = true;
        try {
            Sequence seq = null;
            while (line != null) {
                while (line.charAt(0) == ';') {
                    int end;
                    if (typePattern.matcher(line).find()) {
                        if (pairingmaskPattern.matcher(line).find()) {
                            seq = new PairingMask();
                        } else if (treePattern.matcher(line).find()) {
                            seq = new Sequence(3);
                        } else if (arbitraryPattern.matcher(line).find()) {
                            seq = new Sequence(3);
                        } else {
                            int alphabet = 1;
                            seq = new Sequence(alphabet);
                        }
                    } else if (colPattern.matcher(line).find()) {
                        Matcher m = numberPattern.matcher(line);
                        m.find();
                        end = m.end();
                        int colNumber = Integer.parseInt(line.substring(m.start(), end));
                        m = wordPattern.matcher(line);
                        m.find(end);
                        String colLabel = line.substring(m.start(), m.end());
                        seq.addColumnLabel(colLabel, colNumber);
                    } else if (entryPattern.matcher(line).find()) {
                        Matcher m = entryPattern.matcher(line);
                        m.find();
                        end = m.end();
                        m = wordPattern.matcher(line);
                        m.find(end);
                        seq.setLabel(line.substring(m.start(), m.end()));
                    } else if (seq != null && !line.startsWith("; ----------")) {
                        seq.addInformation(line.substring(2));
                    }
                    line = this.readLine();
                }
                seq.prepareForColumns();
                do {
                    seq.addColumns(line);
                } while (!(line = this.readLine()).startsWith(";"));
                int[] pairings = seq.finalProcessing();
                if (seq instanceof PairingMask) {
                    this.alignment.addPairingMask((PairingMask)seq);
                } else {
                    seq.setNumber(number);
                    ++number;
                    if (this.alignment.getSequence(seq.getLabel()) == null) {
                        this.alignment.addSequence(seq);
                    }
                }
                line = this.readLine();
                seq = null;
            }
            this.alignment.getSequences().nextElement();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public Alignment getAlignment() {
        return this.alignment;
    }
}

