/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.alignmenttools.io;

import dk.kvl.alignmenttools.Alignment;
import dk.kvl.alignmenttools.io.AlignmentWriter;
import dk.kvl.sequencetools.PairingMask;
import dk.kvl.sequencetools.Sequence;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;

public class WideFileWriter
extends BufferedWriter
implements AlignmentWriter {
    private Alignment alignment = null;
    private File file = null;
    private int longestName = -1;

    public WideFileWriter(Alignment alignment, File file) throws IOException {
        super(new FileWriter(file));
        this.alignment = alignment;
        this.setLongestName();
        this.writeAlignment();
        this.close();
    }

    public boolean writeTitle(String name) throws IOException {
        this.write(name, 0, name.length());
        String blank = "                                                                           ";
        this.write(blank, 0, this.longestName - name.length() + 2);
        return true;
    }

    protected void writeLine(char[] line) throws IOException {
        this.write(line, 0, line.length);
        this.newLine();
    }

    protected void writeAlignment() throws IOException {
        PairingMask mask = this.alignment.getPairingMask();
        if (mask != null) {
            this.writeTitle(mask.getLabel());
            this.writeLine(mask.getSequenceArray());
        }
        String[] names = this.alignment.getSortedNames();
        for (int i = 0; i < names.length; ++i) {
            Sequence seq = this.alignment.getSequence(names[i]);
            this.writeTitle(seq.getLabel());
            this.writeLine(seq.getSequenceArray());
        }
    }

    public void setLongestName() {
        String s;
        if (this.alignment.getPairingMask() != null) {
            Enumeration p = this.alignment.getPairingMaskKeys();
            while (p.hasMoreElements()) {
                s = (String)p.nextElement();
                if (s.length() <= this.longestName) continue;
                this.longestName = s.length();
            }
        }
        Enumeration e = this.alignment.getSequenceKeys();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            if (s.length() <= this.longestName) continue;
            this.longestName = s.length();
        }
    }
}

