/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.controller;

import dk.kvl.gui.properties.AlignmentProperties;
import dk.kvl.tools.Parameter;
import dk.kvl.tools.Program;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ProgramController
implements ErrorHandler {
    private final Document document;
    private Hashtable programs = new Hashtable();

    public ProgramController() throws ParserConfigurationException, SAXException, IOException {
        this(new File(AlignmentProperties.getPropertyDir() + "programs.xml"));
    }

    public ProgramController(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        DOMParser parser = new DOMParser();
        parser.setFeature("http://xml.org/sax/features/validation", true);
        parser.parse(new InputSource(new FileInputStream(xmlFile)));
        this.document = parser.getDocument();
        this.extractPrograms();
    }

    protected void extractPrograms() {
        NodeList nl = this.document.getElementsByTagName("program");
        for (int i = 0; i < nl.getLength(); ++i) {
            Program prog = new Program(nl.item(i));
            this.programs.put(prog.getName(), prog);
        }
    }

    public Program getProgram(String key) {
        return (Program)this.programs.get(key);
    }

    public void error(SAXParseException spe) {
        System.out.println("Line: " + spe.getLineNumber() + ", Error: " + spe.getMessage());
    }

    public void fatalError(SAXParseException spe) {
        System.out.println("Line: " + spe.getLineNumber() + ", Fatal error: " + spe.getMessage());
    }

    public void warning(SAXParseException spe) {
        System.out.println("Line: " + spe.getLineNumber() + ", Warning: " + spe.getMessage());
    }

    public Enumeration getProgramKeys() {
        return this.programs.keys();
    }

    public void selectProgram(String name, Hashtable checkBoxes) {
        if (this.getProgram(name) != null) {
            this.getProgram(name).setSelected(true);
            if (this.getProgram(name).getDepends() != null) {
                if (checkBoxes.get(this.getProgram(name).getDepends()) != null) {
                    ((JCheckBox)checkBoxes.get(this.getProgram(name).getDepends())).setSelected(true);
                }
                this.selectProgram(this.getProgram(name).getDepends(), checkBoxes);
            }
        }
    }

    public boolean isProgramSelected(String name) {
        return this.getProgram(name).isSelected();
    }

    public void unselectProgram(String name, Hashtable checkBoxes) {
        this.getProgram(name).setSelected(false);
        Enumeration e = this.programs.keys();
        while (e.hasMoreElements()) {
            String pName = (String)e.nextElement();
            if (!this.isProgramSelected(pName) || !this.getProgram(pName).getDepends().equals(name)) continue;
            ((JCheckBox)checkBoxes.get(pName)).setSelected(false);
            this.unselectProgram(pName, checkBoxes);
        }
    }

    public int getNumberOfPrograms() {
        return this.programs.size();
    }

    public void reset() {
        Enumeration e = this.programs.keys();
        while (e.hasMoreElements()) {
            String pName = (String)e.nextElement();
            Program currProgram = this.getProgram(pName);
            if (this.isProgramSelected(pName)) {
                currProgram.setSelected(false);
                currProgram.reset();
            }
            Enumeration parameters = currProgram.getParameters();
            while (parameters.hasMoreElements()) {
                Parameter param = (Parameter)parameters.nextElement();
                if (!param.isSelected() || param.isDefaultSelected()) continue;
                param.setSelected(false);
            }
        }
    }
}

