/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.gui.components;

import dk.kvl.controller.AlignmentController;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JPanel;

public class AlignmentCanvas
extends JPanel
implements MouseListener {
    private AlignmentController controller;
    private Vector mouseListeners = new Vector();
    private int zoom = 2;
    private Frame owner;

    public AlignmentCanvas(Frame owner, AlignmentController aController) {
        this.controller = aController;
        super.addMouseListener(this);
        this.owner = owner;
        this.setZoom(this.zoom);
    }

    public void paint(Graphics g) {
        super.paint(g);
        String[] sequences = this.controller.getSortedNames();
        for (int i = 0; i < sequences.length; ++i) {
            for (int j = 0; j < this.controller.getAlignmentLength(); ++j) {
                Color bColor = this.controller.getBackground(sequences[i], j);
                g.setColor(bColor);
                g.fillRect(j * this.zoom, i * this.zoom, this.zoom, this.zoom);
            }
        }
    }

    public void setZoom(int newZoom) {
        if (newZoom > 0) {
            this.zoom = newZoom;
            this.setPreferredSize(new Dimension(this.controller.getAlignmentLength() * this.zoom, this.controller.getNumberOfSequences() * this.zoom));
            this.revalidate();
            this.repaint();
        }
    }

    public int getZoom() {
        return this.zoom;
    }

    public void adjustZoom() {
        int width = this.owner.getWidth() / this.controller.getAlignmentLength();
        this.setZoom(Math.max(width, 1));
    }

    public void addMouseListener(MouseListener listener) {
        this.mouseListeners.add(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.mouseListeners.remove(listener);
    }

    public void mouseClicked(MouseEvent e) {
        MouseEvent newEvent = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), e.getX() / this.zoom, e.getY() / this.zoom, e.getClickCount(), e.isPopupTrigger());
        e.consume();
        for (int i = 0; i < this.mouseListeners.size(); ++i) {
            ((MouseListener)this.mouseListeners.get(i)).mouseClicked(newEvent);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

