/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.gui.properties;

import dk.kvl.controller.ProgramController;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class AlignmentProperties
extends Properties
implements Serializable {
    private Font tableFont;
    private Color background = new Color(255, 255, 204);
    private Color textColor = Color.BLACK;
    private Color sequenceColor = Color.BLACK;
    private Color gapColor = Color.BLACK;
    private Color uColor = Color.BLUE;
    private Color aColor = Color.RED;
    private Color gColor = new Color(255, 153, 0);
    private Color cColor = Color.GREEN;
    private Color primarySelectionColor = new Color(110, 176, 241);
    private Color secondarySelectionColor = new Color(110, 176, 241);
    private String lastPath;
    private transient ProgramController programController = new ProgramController();
    private boolean baseColoring = false;
    private boolean colored = true;
    private static String homeDir;
    private static String projectDir;
    private boolean grid = false;

    public AlignmentProperties() throws Exception {
        try {
            this.setFontName("verdana");
            this.setFontSize(10.0f);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error creating tablefont");
            e.printStackTrace();
        }
    }

    public String getLastPath() {
        return this.getProperty("lastpath");
    }

    public void setLastPath(String path) {
        this.setProperty("lastpath", path);
    }

    public void setAColor(Color newColor) {
        this.aColor = newColor;
    }

    public void setPrimarySelectionColor(Color newColor) {
        this.primarySelectionColor = newColor;
    }

    public void setSecondarySelectionColor(Color newColor) {
        this.secondarySelectionColor = newColor;
    }

    public void setUColor(Color newColor) {
        this.uColor = newColor;
    }

    public void setGColor(Color newColor) {
        this.gColor = newColor;
    }

    public void setSequenceColor(Color newColor) {
        this.sequenceColor = newColor;
    }

    public void setCColor(Color newColor) {
        this.cColor = newColor;
    }

    public Color getAColor() {
        return this.aColor;
    }

    public Color getPrimarySelectionColor() {
        return this.primarySelectionColor;
    }

    public Color getSecondarySelectionColor() {
        return this.secondarySelectionColor;
    }

    public Color getUColor() {
        return this.uColor;
    }

    public Color getGColor() {
        return this.gColor;
    }

    public Color getCColor() {
        return this.cColor;
    }

    public Font getTableFont() {
        return this.tableFont;
    }

    public void setTableFont(Font newFont) {
        this.tableFont = newFont;
    }

    public boolean isBaseColoringEnabled() {
        return this.baseColoring;
    }

    public void setBaseColoring(boolean enabled) {
        this.baseColoring = enabled;
    }

    public Color getGapColor() {
        return this.gapColor;
    }

    public Color getSequenceColor() {
        return this.sequenceColor;
    }

    public boolean createMainViewFromBeginning() {
        return true;
    }

    public static String getProjectDir() {
        return projectDir;
    }

    public static String getLogDir() {
        File f = new File(projectDir + "/log/");
        if (!f.exists()) {
            f.mkdirs();
        }
        return projectDir + "/log";
    }

    public static String getTmpDir() {
        File f = new File(projectDir + "/tmp/");
        if (!f.exists()) {
            f.mkdirs();
        }
        return projectDir + "/tmp/";
    }

    public static String getHomeDir() {
        return homeDir;
    }

    public boolean isColored() {
        return this.colored;
    }

    public static void setHomeDir(String home) {
        homeDir = home;
    }

    public static String getPropertyDir() {
        return homeDir + "/properties/";
    }

    public static String getIconDir() {
        return homeDir + "/lib/icons";
    }

    public boolean isGrid() {
        return this.grid;
    }

    public void setGrid(boolean b) {
        this.grid = b;
    }

    public void setFontSize(float f) {
        this.tableFont = this.tableFont.deriveFont(f);
        UIManager.put("Table.font", this.tableFont);
    }

    public float getFontSize() {
        if (this.tableFont == null || this.tableFont.getSize() < 0 || this.tableFont.getSize() > 16) {
            return 10.0f;
        }
        return this.tableFont.getSize();
    }

    public void setFontName(String name) {
        name = name.toLowerCase() + ".ttf";
        try {
            Font newFont = Font.createFont(0, new FileInputStream(new File(AlignmentProperties.getHomeDir() + "/fonts/" + name)));
            this.tableFont = newFont.deriveFont(this.getFontSize());
            UIManager.put("Table.font", this.tableFont);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error creating font");
            e.printStackTrace();
        }
    }

    public void setBackground(Color c) {
        this.background = c;
    }

    public void setTextColor(Color c) {
        this.textColor = c;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public Color getBackground() {
        return this.background;
    }

    public static void setProjectDir(String dir) {
        File prjDir = new File(dir);
        if (!prjDir.exists()) {
            prjDir.mkdirs();
        }
        projectDir = dir;
    }

    public void loadProgramController() throws Exception {
        this.programController = new ProgramController();
    }

    public ProgramController getProgramController() throws Exception {
        if (this.programController == null) {
            this.loadProgramController();
        }
        return this.programController;
    }
}

