/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.alignmenttools;

import dk.kvl.alignmenttools.Subalignment;
import dk.kvl.sequencetools.PairingMask;
import dk.kvl.sequencetools.Sequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Alignment {
    public static int ALPHABETSORT = 1;
    public static int ORIGINALSORT = 2;
    private Hashtable sequences = null;
    private Hashtable pairingMasks = null;
    private int type = -1;
    private int length = -1;
    private String label = null;
    private char[] alphabet = null;
    private boolean changed = false;
    private String pairingMaskName = null;
    private StringBuffer header;
    private int sort = ORIGINALSORT;
    private String[] sortedNames;

    public Alignment(Hashtable seqs, Hashtable pMasks) {
        this.pairingMasks = pMasks != null ? pMasks : new Hashtable();
        this.sequences = seqs != null ? seqs : new Hashtable();
        this.checkAlignment();
        this.sort();
    }

    public boolean hasPairingmask() {
        return this.pairingMasks != null && this.pairingMasks.size() != 0;
    }

    public Alignment() {
        this.sequences = new Hashtable();
        this.pairingMasks = new Hashtable();
    }

    public void addPairingMask(PairingMask mask) {
        this.pairingMasks.put(mask.getLabel(), mask);
        this.pairingMaskName = mask.getLabel();
        this.changed = true;
    }

    public void setActivePairingmask(String name) {
        this.pairingMaskName = name;
    }

    public boolean isValidSymbol(char symbol) {
        boolean result = false;
        Enumeration e = this.getSequenceKeys();
        if (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            result = this.getSequence(name).getAlphabet().isValidSymbol(symbol);
        }
        return result;
    }

    public String getPairingmaskName() {
        return this.pairingMaskName;
    }

    public PairingMask getPairingMask(String key) {
        if (key != null) {
            return (PairingMask)this.pairingMasks.get(key);
        }
        return null;
    }

    public PairingMask getPairingMask() {
        if (this.pairingMaskName != null) {
            return (PairingMask)this.pairingMasks.get(this.pairingMaskName);
        }
        return null;
    }

    public boolean addSequence(Sequence newSequence) {
        newSequence.setNumber(this.sequences.size());
        boolean valid = false;
        if (newSequence != null && this.getSequence(newSequence.getLabel()) == null) {
            if (this.getPairingMask() != null) {
                // empty if block
            }
            if (this.length == -1 && this.type == -1) {
                this.length = newSequence.getLength();
                this.type = newSequence.getType();
            }
            this.sequences.put(newSequence.getLabel(), newSequence);
            if (this.length < newSequence.getLength()) {
                this.length = newSequence.getLength();
            }
            this.changed = true;
            valid = true;
        }
        return valid;
    }

    public boolean addOldSequence(Sequence sequence) {
        Sequence o = this.sequences.put(sequence.getLabel(), sequence);
        return o != null;
    }

    public boolean checkAlignment() {
        boolean check = true;
        Sequence seq = null;
        Enumeration enumeration = this.sequences.elements();
        while (enumeration.hasMoreElements()) {
            seq = (Sequence)enumeration.nextElement();
            if (this.length == -1 && this.type == -1) {
                this.length = seq.getLength();
                this.type = seq.getType();
                continue;
            }
            if (this.type != seq.getType()) {
                check = false;
                continue;
            }
            if (this.length >= seq.getLength()) continue;
            this.length = seq.getLength();
        }
        if (this.pairingMaskName == null && this.pairingMasks.size() > 0) {
            String key;
            Enumeration e = this.pairingMasks.keys();
            this.pairingMaskName = key = (String)e.nextElement();
        }
        return check;
    }

    protected void setTypeAndLength() {
        Enumeration enumeration = this.sequences.elements();
        Sequence seq = null;
        boolean counter = false;
        while (enumeration.hasMoreElements()) {
            seq = (Sequence)enumeration.nextElement();
            if (seq.getType() == 3) continue;
            this.type = seq.getType();
            this.length = seq.getLength();
            break;
        }
    }

    public int getLength() {
        return this.length;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return "Type: " + this.type + ", length: " + this.length + ", number of sequences: " + this.sequences.size() + ", number of pairingmasks = " + this.pairingMasks.size();
    }

    public Sequence getSequence(String key) {
        if (key != null) {
            return (Sequence)this.sequences.get(key);
        }
        return null;
    }

    public Enumeration getSequenceKeys() {
        return this.sequences.keys();
    }

    public Sequence removeSequence(String key) {
        Object o = this.sequences.remove(key);
        if (o != null) {
            this.changed = true;
            return (Sequence)o;
        }
        return null;
    }

    public int getNumberOfSequences() {
        return this.sequences.size();
    }

    public int getNumberOfPairingMasks() {
        return this.pairingMasks.size();
    }

    public Enumeration getPairingMaskKeys() {
        return this.pairingMasks.keys();
    }

    public Enumeration getSequences() {
        return this.sequences.elements();
    }

    public boolean toUpperCase(String name, int index) {
        boolean result = false;
        if (this.getSequence(name) != null && index >= 0 && index <= this.length && (result = this.getSequence(name).toUpperCase(index))) {
            this.changed = true;
        }
        return result;
    }

    public int[] toUpperCase(String name, int[] index) {
        int[] result = new int[index.length];
        for (int i = 0; i < index.length; ++i) {
            result[i] = -1;
            if (!this.toUpperCase(name, index[i])) continue;
            result[i] = index[i];
        }
        return result;
    }

    public int[][] toUpperCase(String[] names, int[] index) {
        int[][] result = new int[names.length][];
        for (int i = 0; i < names.length; ++i) {
            result[i] = this.toUpperCase(names[i], index);
        }
        return result;
    }

    public void toLowerCase() {
        Enumeration e = this.getSequences();
        while (e.hasMoreElements()) {
            Sequence seq = (Sequence)e.nextElement();
            seq.toLowerCase();
        }
    }

    public boolean toLowerCase(String name, int index) {
        boolean result = false;
        if (this.getSequence(name) != null && index >= 0 && index <= this.length && (result = this.getSequence(name).toLowerCase(index))) {
            this.changed = true;
        }
        return result;
    }

    public int[] toLowerCase(String name, int[] index) {
        int[] result = new int[index.length];
        for (int i = 0; i < index.length; ++i) {
            result[i] = -1;
            if (!this.toLowerCase(name, index[i])) continue;
            result[i] = index[i];
        }
        return result;
    }

    public int[][] toLowerCase(String[] names, int[] index) {
        int[][] result = new int[names.length][];
        for (int i = 0; i < names.length; ++i) {
            result[i] = this.toLowerCase(names[i], index);
        }
        return result;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean chg) {
        this.changed = chg;
    }

    public char changeSymbol(String sequenceName, int index, char newChar) {
        this.changed = true;
        Sequence seq = this.getSequence(sequenceName);
        if (seq == null && (seq = this.getPairingMask(sequenceName)) == null) {
            return '!';
        }
        return seq.changeSymbol(newChar, index);
    }

    public char[][] changeSymbol(String[] sequenceNames, int[] index, char newChar) {
        char[][] result = new char[sequenceNames.length][];
        boolean pm = false;
        for (int i = 0; i < sequenceNames.length; ++i) {
            Sequence seq = this.getSequence(sequenceNames[i]);
            if (seq == null) {
                seq = this.getPairingMask(sequenceNames[i]);
                pm = true;
            }
            if (seq == null) continue;
            result[i] = seq.changeSymbol(newChar, index);
        }
        this.updatePairings();
        this.changed = true;
        return result;
    }

    public boolean updateAlignment(Subalignment changedAlignment) {
        char symbol;
        int i;
        boolean result = false;
        String name = null;
        int[] cell = new int[]{};
        Enumeration e = changedAlignment.getSequenceKeys();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            for (i = 0; i < changedAlignment.getLength(); ++i) {
                symbol = changedAlignment.getSequence(name).getSymbolAt(i);
                this.changeSymbol(name, i + changedAlignment.getStartIndex(), symbol);
            }
        }
        e = changedAlignment.getPairingMaskKeys();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            for (i = 0; i < changedAlignment.getLength(); ++i) {
                symbol = changedAlignment.getPairingMask(name).getSymbolAt(i);
                this.changeSymbol(name, i + changedAlignment.getStartIndex(), symbol);
            }
        }
        return result;
    }

    public char[] getAlphabet() {
        return Sequence.getAlphabet(this.type).getAlphabet();
    }

    public void setHeader(StringBuffer newHead) {
        this.header = newHead;
    }

    public void prepareAlignment() {
        this.checkAlignment();
        if (this.getPairingMask() != null) {
            // empty if block
        }
    }

    public String getSequenceInfo(String sequence) {
        Sequence seq = this.getSequence(sequence);
        if (seq != null) {
            return seq.getInformation();
        }
        return null;
    }

    public String getInformation() {
        if (this.header != null) {
            return this.header.toString();
        }
        return null;
    }

    public void setInformation(String text) {
        this.header = new StringBuffer(text);
    }

    public String[] rotateLeft(String[] sequences, int start, int end) {
        Sequence seq;
        int i;
        String[] rotated = new String[sequences.length];
        boolean allowed = true;
        for (i = 0; i < sequences.length; ++i) {
            seq = this.getSequence(sequences[i]);
            if (seq == null) {
                seq = this.getPairingMask(sequences[i]);
            }
            if (seq == null || seq.getSymbolAt(end) == '-') continue;
            allowed = false;
            rotated = null;
        }
        while (allowed) {
            for (i = 0; i < sequences.length; ++i) {
                seq = this.getSequence(sequences[i]);
                if (seq == null) {
                    seq = this.getPairingMask(sequences[i]);
                }
                if (seq == null || !seq.rotateLeft(start, end)) continue;
                rotated[i] = sequences[i];
            }
            for (i = 0; i < sequences.length; ++i) {
                seq = this.getSequence(sequences[i]);
                if (seq == null) {
                    seq = this.getPairingMask(sequences[i]);
                }
                if (seq == null || seq.getSymbolAt(end) == '-') continue;
                allowed = false;
            }
        }
        return rotated;
    }

    public String[] rotateRight(String[] sequences, int start, int end) {
        String[] rotated = new String[sequences.length];
        boolean allowed = true;
        for (int i = 0; i < sequences.length; ++i) {
            Sequence seq = this.getSequence(sequences[i]);
            if (seq == null) {
                seq = this.getPairingMask(sequences[i]);
            }
            if (seq == null || seq.getSymbolAt(start) == '-') continue;
            allowed = false;
            rotated = null;
        }
        while (allowed) {
            int i;
            Sequence seq = null;
            for (i = 0; i < sequences.length; ++i) {
                seq = this.getSequence(sequences[i]);
                if (seq == null) {
                    seq = this.getPairingMask(sequences[i]);
                }
                if (seq == null || !seq.rotateRight(start, end)) continue;
                rotated[i] = sequences[i];
            }
            for (i = 0; i < sequences.length; ++i) {
                seq = this.getSequence(sequences[i]);
                if (seq == null) {
                    seq = this.getPairingMask(sequences[i]);
                }
                if (seq == null || seq.getSymbolAt(start) == '-') continue;
                allowed = false;
            }
        }
        return rotated;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String name) {
        this.label = name;
    }

    public void emptyInfo() {
        this.header = new StringBuffer();
        Enumeration e = this.sequences.keys();
        while (e.hasMoreElements()) {
            ((Sequence)this.sequences.get((String)e.nextElement())).emptyInfo();
        }
        e = this.pairingMasks.keys();
        while (e.hasMoreElements()) {
            ((PairingMask)this.pairingMasks.get(e.nextElement())).emptyInfo();
        }
    }

    public void setSort(int sortType) {
        this.sort = sortType == ALPHABETSORT ? ALPHABETSORT : ORIGINALSORT;
        this.sort();
    }

    public int getSort() {
        return this.sort;
    }

    public void sort() {
        Enumeration e = this.getSequenceKeys();
        if (this.sort == ORIGINALSORT) {
            ArrayList<Sequence> sorted = new ArrayList<Sequence>();
            Object[] sortedSequences = new Sequence[this.getNumberOfSequences()];
            this.sortedNames = new String[this.getNumberOfSequences()];
            while (e.hasMoreElements()) {
                sorted.add(this.getSequence((String)e.nextElement()));
            }
            sortedSequences = sorted.toArray(new Sequence[sorted.size()]);
            Arrays.sort(sortedSequences);
            for (int i = 0; i < sortedSequences.length; ++i) {
                this.sortedNames[i] = ((Sequence)sortedSequences[i]).getLabel();
            }
        } else {
            Vector<String> v = new Vector<String>();
            while (e.hasMoreElements()) {
                v.add(this.getSequence((String)e.nextElement()).getLabel());
                Collections.sort(v);
                this.sortedNames = v.toArray(new String[0]);
            }
        }
    }

    public String[] getSortedNames() {
        this.sort();
        return this.sortedNames;
    }

    public boolean addPairing(int indexA, int indexB, char symbol) {
        if (this.getPairingMask() != null) {
            return false;
        }
        boolean result = this.getPairingMask().addPairing(indexA, indexB, symbol);
        if (result) {
            this.updatePairings();
        }
        return result;
    }

    public char removePairing(int indexA, int indexB) {
        if (this.getPairingMask() != null) {
            return '!';
        }
        char result = this.getPairingMask().removePairing(indexA, indexB);
        if (result != '!') {
            this.updatePairings();
        }
        return result;
    }

    public void updatePairings() {
        if (this.getPairingMask() != null) {
            Enumeration e = this.getSequenceKeys();
            this.getPairingMask().setPairings(PairingMask.updatePairings(this.getPairingMask().getSequenceArray()));
            while (e.hasMoreElements()) {
                Sequence seq = this.getSequence((String)e.nextElement());
                seq.setPairingmask(this.getPairingMask().getSequenceArray());
            }
        }
    }

    public char[] removeColumn(int index) {
        char[] removed = new char[this.getNumberOfSequences() + 1];
        int i = 0;
        if (index >= 0 && index < this.getLength()) {
            Enumeration e = this.getSequenceKeys();
            while (e.hasMoreElements()) {
                removed[i] = this.getSequence((String)e.nextElement()).removeColumn(index);
                ++i;
            }
            if (this.getPairingMask() != null) {
                removed[i] = this.getPairingMask().removeColumn(index);
            }
            --this.length;
        }
        return removed;
    }

    public void addColumn(int index, char symbol) {
        if (index >= 0 && this.isValidSymbol(symbol)) {
            Enumeration e = this.getSequenceKeys();
            while (e.hasMoreElements()) {
                this.getSequence((String)e.nextElement()).addColumn(index, symbol);
            }
            if (this.getPairingMask() != null) {
                this.getPairingMask().addColumn(index, symbol);
            }
            ++this.length;
        }
    }

    public void updateLength() {
        ++this.length;
    }

    public boolean pairColumns(int col1, int col2, char mask) {
        Enumeration e = this.getSequences();
        this.getPairingMask().pairColumns(col1, col2, mask);
        while (e.hasMoreElements()) {
            Sequence seq = (Sequence)e.nextElement();
            seq.pairBases(col1, col2);
        }
        return true;
    }

    public boolean unpairColumns(int col1, int col2) {
        char c = this.getPairingMask().removePairing(col1, col2);
        if (c != '!') {
            Enumeration e = this.getSequenceKeys();
            while (e.hasMoreElements()) {
                String seq = (String)e.nextElement();
                this.toLowerCase(seq, col1);
                this.toLowerCase(seq, col2);
            }
            return true;
        }
        return false;
    }

    public void pair(String[] names, int[] cols) {
        if (cols.length % 2 == 0) {
            for (int i = 0; i < cols.length / 2; ++i) {
                for (int j = 0; j < names.length; ++j) {
                    Sequence seq = this.getSequence(names[j]);
                    seq.pairBases(cols[i], cols[cols.length - 1 - i]);
                }
            }
            this.updatePairings();
        }
    }

    public boolean fitCases() {
        Enumeration e = this.getSequenceKeys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Sequence seq = this.getSequence(name);
            if (seq == null) continue;
            for (int i = 0; i < this.getLength(); ++i) {
                if (this.getPairingMask() != null && this.getPairingMask().getPairing(i) >= 0 && seq.getAlphabet().isPairing(seq.getSymbolAt(i), seq.getSymbolAt(this.getPairingMask().getPairing(i)))) {
                    seq.pairBases(i, this.getPairingMask().getPairing(i));
                    continue;
                }
                seq.toLowerCase(i);
                seq.deletePairing(i);
            }
        }
        return true;
    }

    public Hashtable unpair(String[] names, int[] cols) {
        Hashtable<String, int[][]> ht = new Hashtable<String, int[][]>();
        for (int i = 0; i < names.length; ++i) {
            ht.put(names[i], this.getSequence(names[i]).unpair(cols));
        }
        return ht;
    }

    public PairingMask removePairingmask(String name) {
        Object o = this.pairingMasks.remove(name);
        if (o != null) {
            this.pairingMaskName = null;
            return (PairingMask)o;
        }
        return null;
    }
}

