/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.alignmenttools.io;

import dk.kvl.alignmenttools.Alignment;
import dk.kvl.alignmenttools.io.AlignmentWriter;
import dk.kvl.sequencetools.PairingMask;
import dk.kvl.sequencetools.Sequence;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.JOptionPane;

public class ColWriter
extends BufferedWriter
implements AlignmentWriter {
    private final Alignment alignment;
    private boolean colors = true;
    private boolean pairingmasks = false;

    public ColWriter(File outFile, Alignment alignment, boolean preserveColors, boolean allPairingMasks) throws IOException {
        super(new FileWriter(outFile));
        this.alignment = alignment;
        this.pairingmasks = allPairingMasks;
        this.colors = preserveColors;
        this.writeAlignmentHeader();
        this.writeSequences();
        this.flush();
    }

    public ColWriter(File outFile, Alignment alignment) throws IOException {
        this(outFile, alignment, true, true);
    }

    protected void writeAlignmentHeader() throws IOException {
        try {
            String inf = this.alignment.getInformation().trim();
            if (inf != null && inf.length() > 0) {
                char[] info = inf.toCharArray();
                if (info[0] != ';') {
                    this.write(59);
                    this.write(32);
                }
                for (int i = 0; i < info.length; ++i) {
                    this.write(info[i]);
                    if (info[i] != '\r' && info[i] != '\n' && info[i] != '\f') continue;
                    this.write(59);
                    this.write(32);
                }
            }
            String sep = "\n; ==========\n";
            this.write(sep, 0, sep.length());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void writeSequences() throws IOException {
        if (this.pairingmasks) {
            Enumeration e = this.alignment.getPairingMaskKeys();
            while (e.hasMoreElements()) {
                PairingMask seq = this.alignment.getPairingMask((String)e.nextElement());
                this.writeSequenceHeader(seq);
                this.writeSequence(seq);
            }
        } else if (this.alignment.getPairingMask() != null) {
            PairingMask seq = this.alignment.getPairingMask();
            this.writeSequenceHeader(seq);
            this.writeSequence(seq);
        }
        int oldSort = this.alignment.getSort();
        this.alignment.setSort(Alignment.ORIGINALSORT);
        String[] keys = this.alignment.getSortedNames();
        for (int i = 0; i < keys.length; ++i) {
            this.writeSequence(keys[i]);
        }
        this.alignment.setSort(oldSort);
    }

    protected void writeSequence(String name) {
        Sequence seq = this.alignment.getSequence(name);
        try {
            this.writeSequenceHeader(seq);
            this.writeSequence(seq);
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Exception thrown: ColWriter:writeSequence()");
        }
    }

    public void writeSequenceHeader(Sequence seq) throws IOException {
        String column;
        String type = "; TYPE  " + Sequence.getAlphabet(seq.getType()).getLabel() + "\n";
        this.write(type, 0, type.length());
        String column1 = "; COL 1 label\n";
        this.write(column1, 0, column1.length());
        String column2 = "; COL 2 residue\n";
        this.write(column2, 0, column2.length());
        String column3 = "; COL 3 seqpos\n";
        this.write(column3, 0, column3.length());
        String column4 = "; COL 4 alignpos\n";
        this.write(column4, 0, column4.length());
        int columnNr = 5;
        if (seq.getPairing(0) != -2) {
            String column5 = "; COL 5  align_bp\n";
            this.write(column5, 0, column5.length());
            ++columnNr;
        }
        String[] colLabels = seq.getColumnLabels();
        for (int i = 0; i < colLabels.length; ++i) {
            column = "; COL " + columnNr + "    " + colLabels[i] + "\n";
            this.write(column, 0, column.length());
            ++columnNr;
        }
        if (seq.isBackgroundColred()) {
            column = "; COL " + columnNr++ + "   color_r\n";
            this.write(column, 0, column.length());
            column = "; COL " + columnNr++ + "   color_g\n";
            this.write(column, 0, column.length());
            column = "; COL " + columnNr++ + "   color_b\n";
            this.write(column, 0, column.length());
        }
        if (seq.isForegroundColred()) {
            column = "; COL " + columnNr++ + "   color2_r\n";
            this.write(column, 0, column.length());
            column = "; COL " + columnNr++ + "   color2_g\n";
            this.write(column, 0, column.length());
            column = "; COL " + columnNr++ + "   color2_b\n";
            this.write(column, 0, column.length());
        }
        String entry = "; ENTRY  " + seq.getLabel() + "\n";
        this.write(entry, 0, entry.length());
        try {
            String inf = seq.getInformation().trim();
            if (inf != null && inf.length() > 0) {
                char[] info = inf.toCharArray();
                if (info[0] != ';') {
                    this.write(59);
                    this.write(32);
                }
                for (int i = 0; i < info.length; ++i) {
                    this.write(info[i]);
                    if (info[i] != '\r' && info[i] != '\n' && info[i] != '\f') continue;
                    this.write(59);
                    this.write(32);
                }
                if (info[info.length - 1] != '\r' || info[info.length - 1] != '\n' || info[info.length - 1] != '\f') {
                    this.write(10);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.write("; ----------\n", 0, 13);
    }

    public void writeSequence(Sequence seq) throws IOException {
        int seqpos = 1;
        for (int i = 0; i < seq.getLength(); ++i) {
            float[] b;
            String col3;
            String col1;
            String col2 = seq.getSymbolAt(i) + "";
            if (col2.equals("-")) {
                col1 = "G";
                col3 = ".";
            } else {
                col1 = "N";
                col3 = "" + seqpos;
                ++seqpos;
            }
            String col4 = "" + (i + 1);
            StringBuffer line = new StringBuffer(col1 + "    " + col2 + "    " + col3 + "    " + col4);
            String col5 = null;
            if (seq.getPairing(i) > 0) {
                col5 = "" + (seq.getPairing(i) + 1);
            } else if (seq.getPairing(0) != -2) {
                col5 = ".";
            }
            if (col5 != null) {
                line.append("    " + col5);
            }
            String[] cols = seq.getColumnInfo(i);
            for (int j = 0; j < seq.getColumnLabels().length; ++j) {
                line.append("    " + cols[j]);
            }
            if (seq.isBackgroundColred() && (b = seq.getBackgroundColor(i).getRGBColorComponents(null)).length == 3) {
                line.append("   " + b[0] + "   " + b[1] + "   " + b[2]);
            }
            if (seq.isForegroundColred() && (b = seq.getForegroundColor(i).getRGBColorComponents(null)).length == 3) {
                line.append("   " + b[0] + "   " + b[1] + "   " + b[2]);
            }
            line.append("\n");
            this.write(line.toString(), 0, line.length());
        }
        this.write("; **********\n", 0, 13);
    }

    public void writePairingmask(PairingMask mask) throws IOException {
        String column;
        String type = "; TYPE pairingmask\n";
        this.write(type, 0, type.length());
        String column1 = "; COL 1    label\n";
        this.write(column1, 0, column1.length());
        String column2 = "; COL 2    residue\n";
        this.write(column2, 0, column2.length());
        String column3 = "; COL 3    alignpos\n";
        this.write(column3, 0, column3.length());
        int columnNr = 4;
        String[] colLabels = mask.getColumnLabels();
        for (int i = 0; i < colLabels.length; ++i) {
            column = "; COL " + columnNr + "    " + colLabels[i] + "\n";
            this.write(column, 0, column.length());
            ++columnNr;
        }
        if (mask.isBackgroundColred()) {
            column = "; COL " + columnNr++ + "   color_r\n";
            this.write(column, 0, column.length());
            column = "; COL " + columnNr++ + "   color_g\n";
            this.write(column, 0, column.length());
            column = "; COL " + columnNr++ + "   color_b\n";
            this.write(column, 0, column.length());
        }
        if (mask.isForegroundColred()) {
            column = "; COL " + columnNr++ + "   color2_r\n";
            this.write(column, 0, column.length());
            column = "; COL " + columnNr++ + "   color2_g\n";
            this.write(column, 0, column.length());
            column = "; COL " + columnNr++ + "   color2_b\n";
            this.write(column, 0, column.length());
        }
        String entry = "; ENTRY   " + mask.getLabel() + "\n";
        this.write(entry, 0, entry.length());
        this.write(mask.getInformation(), 0, mask.getInformation().length());
        this.write("; ----------\n", 0, 13);
        for (int i = 0; i < mask.getLength(); ++i) {
            float[] b;
            StringBuffer l = new StringBuffer();
            l.append("M    " + mask.getSymbolAt(i) + "    " + (i + 1));
            if (mask.isBackgroundColred() && (b = mask.getBackgroundColor(i).getRGBColorComponents(null)).length == 3) {
                l.append("   " + b[0] + "   " + b[1] + "   " + b[2]);
            }
            if (mask.isForegroundColred() && (b = mask.getForegroundColor(i).getRGBColorComponents(null)).length == 3) {
                l.append("   " + b[0] + "   " + b[1] + "   " + b[2]);
            }
            String[] cols = mask.getColumnInfo(i);
            for (int j = 0; j < mask.getColumnLabels().length; ++j) {
                l.append("    " + cols[j]);
            }
            l.append("\n");
            this.write(l.toString(), 0, l.length());
        }
        this.write("; **********\n", 0, 13);
    }
}

