/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.controller;

import dk.kvl.gui.properties.AlignmentProperties;
import dk.kvl.gui.properties.ProjectProperties;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JOptionPane;

public class ProjectController {
    private Hashtable projects;

    public ProjectController() {
        this.loadProjects();
    }

    protected void loadProjects() {
        this.projects = new Hashtable();
        File pDir = new File(AlignmentProperties.getProjectDir());
        String[] fileList = pDir.list();
        if (fileList != null) {
            for (int i = 0; i < fileList.length; ++i) {
                if (!fileList[i].endsWith(".prj")) continue;
                try {
                    ProjectProperties p = new ProjectProperties(fileList[i]);
                    this.projects.put(p.getName(), p);
                    continue;
                }
                catch (IOException ie) {
                    ie.printStackTrace();
                }
            }
        }
    }

    public String[] getProjectNames() {
        this.loadProjects();
        String[] names = new String[this.projects.size()];
        Enumeration e = this.projects.keys();
        int counter = 0;
        while (e.hasMoreElements()) {
            names[counter] = (String)e.nextElement();
            ++counter;
        }
        return names;
    }

    public void addProject(String name, String file, String path) {
        ProjectProperties p = new ProjectProperties(name, file, path);
        try {
            p.store();
            this.projects.put(name, p);
        }
        catch (IOException ie) {
            ie.printStackTrace();
            JOptionPane.showMessageDialog(null, "The projectfile could not be created!");
        }
    }

    public void removeProject() {
    }

    public ProjectProperties getProjectProperties(String name) {
        return (ProjectProperties)this.projects.get(name);
    }
}

