/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.gui.alignment;

import dk.kvl.gui.components.OkCancelPanel;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class SubalignmentSelector
extends JDialog
implements ActionListener {
    private final JLabel nameLabel = new JLabel("Write a name:");
    private final JLabel seqLabel = new JLabel("Choose the sequences:");
    private final JLabel indexLabel = new JLabel("Write the start and end Index:");
    private JTextField nameField = new JTextField();
    private JTextField startField = new JTextField(5);
    private JTextField endField = new JTextField(5);
    private JList seqNames = null;
    private boolean done = false;
    private boolean ok = false;
    private JPanel mainPanel = new JPanel(new BorderLayout());
    private ActionListener listener;

    private SubalignmentSelector(String[] selectedNames, String[] allNames, int start, int end, ActionListener listener) {
        this.getContentPane().setLayout(new BorderLayout());
        this.createNamePanel();
        this.createIntervalPanel();
        this.listener = listener;
        this.startField.setText("" + start);
        this.endField.setText("" + end);
        this.createSequencePanel(selectedNames, allNames);
        this.getContentPane().add("Center", this.mainPanel);
        this.getContentPane().add("Center", this.mainPanel);
        this.setSize(400, 600);
        this.getContentPane().add("South", new OkCancelPanel(this));
        this.setVisible(true);
    }

    public void createNamePanel() {
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BoxLayout(namePanel, 1));
        namePanel.add(this.nameLabel);
        namePanel.add(this.nameField);
        this.mainPanel.add("North", namePanel);
    }

    public void createSequencePanel(String[] selectedNames, String[] allNames) {
        JPanel sequencePanel = new JPanel();
        sequencePanel.setLayout(new BoxLayout(sequencePanel, 1));
        sequencePanel.add(this.seqLabel);
        this.seqNames = new JList<String>(allNames);
        this.seqNames.setSelectionMode(2);
        block0: for (int i = 0; i < selectedNames.length; ++i) {
            for (int j = 0; j < allNames.length; ++j) {
                if (!selectedNames[i].equals(allNames[j])) continue;
                this.seqNames.addSelectionInterval(j, j);
                continue block0;
            }
        }
        JScrollPane nameScroll = new JScrollPane(this.seqNames);
        sequencePanel.add(nameScroll);
        this.mainPanel.add("Center", sequencePanel);
    }

    public void createIntervalPanel() {
        JPanel intervalPanel = new JPanel();
        intervalPanel.setLayout(new BoxLayout(intervalPanel, 1));
        intervalPanel.add(this.indexLabel);
        JPanel indexPanel = new JPanel(new FlowLayout());
        indexPanel.add(new JLabel("From: "));
        indexPanel.add(this.startField);
        indexPanel.add(new JLabel(" to: "));
        indexPanel.add(this.endField);
        intervalPanel.add(indexPanel);
        this.mainPanel.add("South", intervalPanel);
    }

    public int getStart() {
        return Integer.parseInt(this.startField.getText());
    }

    public int getEnd() {
        try {
            int result = Integer.parseInt(this.endField.getText());
            return result;
        }
        catch (NumberFormatException nf) {
            JOptionPane.showMessageDialog(null, nf.getMessage());
            return -1;
        }
    }

    public String getName() {
        return this.nameField.getText();
    }

    public Vector getSelected() {
        Vector<String> names = new Vector<String>();
        for (int i = 0; i < this.seqNames.getSelectedValues().length; ++i) {
            names.add((String)this.seqNames.getSelectedValues()[i]);
        }
        return names;
    }

    public static SubalignmentSelector showSubalignmentSelector(String[] selectedNames, String[] allNames, int start, int end, ActionListener listener) {
        SubalignmentSelector selector = new SubalignmentSelector(selectedNames, allNames, start, end, listener);
        return selector;
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("OK")) {
            if (this.nameField.getText().length() > 1 && this.seqNames.getSelectedIndices().length > 0) {
                this.listener.actionPerformed(new ActionEvent(this, 1, "OK"));
                this.listener = null;
            } else {
                JOptionPane.showMessageDialog(null, "Name and sequence selection needed!");
            }
        } else {
            this.listener = null;
            this.dispose();
        }
    }

    public boolean isOk() {
        return this.ok;
    }

    public boolean isDone() {
        return this.done;
    }
}

