/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.tools;

import dk.kvl.tools.IntArray;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StringTools {
    public static String[] split(String source, char split) {
        if ((source = source.trim()) == null || source.equals("")) {
            return null;
        }
        String[] result = new String[2];
        String[] tmpResult = source.split(String.valueOf(split));
        result[0] = tmpResult[0];
        if (tmpResult.length > 1) {
            result[1] = tmpResult[tmpResult.length - 1];
        }
        return result;
    }

    public static Character[] stringToCharacterArray(String text) {
        Character[] array = new Character[text.length()];
        for (int i = 0; i < text.length(); ++i) {
            array[i] = new Character(text.charAt(i));
        }
        return array;
    }

    public static int[] combineArrays(int[] first, int[] last) {
        int[] newArray = new int[first.length + last.length];
        System.arraycopy(first, 0, newArray, 0, first.length);
        System.arraycopy(last, 0, newArray, first.length, last.length);
        return newArray;
    }

    public static int[] reverseArray(int[] array) {
        int[] newArray = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[array.length - 1 - i];
        }
        return newArray;
    }

    public static int[] combineSortedArrays(int[] first, int[] last) {
        int[] newArray = new int[first.length + last.length];
        if (first.length > 1 && first[0] > first[1]) {
            first = StringTools.reverseArray(first);
        }
        if (last.length > 1 && last[0] > last[1]) {
            last = StringTools.reverseArray(last);
        }
        if (last.length == 0 && first.length == 0) {
            newArray = last;
        } else if (last.length == 0) {
            newArray = first;
        } else if (first.length == 0) {
            newArray = last;
        } else {
            int lastCounter = 0;
            int firstCounter = 0;
            boolean firstOut = false;
            boolean lastOut = false;
            IntArray tmpArray = new IntArray(first.length + last.length);
            for (int i = 0; i < newArray.length; ++i) {
                if (first[firstCounter] < last[lastCounter]) {
                    tmpArray.add(first[firstCounter]);
                    if (++firstCounter != first.length) continue;
                    firstOut = true;
                    break;
                }
                if (first[firstCounter] > last[lastCounter]) {
                    tmpArray.add(last[lastCounter]);
                    if (++lastCounter != last.length) continue;
                    lastOut = true;
                    break;
                }
                tmpArray.add(last[lastCounter]);
                if (++lastCounter == last.length && ++firstCounter == first.length) {
                    firstOut = true;
                    lastOut = true;
                    break;
                }
                if (lastCounter == last.length) {
                    lastOut = true;
                    break;
                }
                if (firstCounter != first.length) continue;
                firstOut = true;
                break;
            }
            if (!firstOut || !lastOut) {
                if (firstOut) {
                    for (int j = lastCounter; j < last.length; ++j) {
                        tmpArray.add(last[j]);
                    }
                } else if (lastOut) {
                    for (int j = firstCounter; j < first.length; ++j) {
                        tmpArray.add(first[j]);
                    }
                }
            }
            newArray = tmpArray.toArray();
        }
        return newArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String inFile, String outFile, boolean bRemoveSource) throws IOException {
        FileInputStream fin = null;
        FileOutputStream fout = null;
        boolean bCanWrite = false;
        boolean bDeleted = false;
        File fTimeIn = new File(inFile);
        File fTimeOut = new File(outFile);
        long lTimeIn = fTimeIn.lastModified();
        try {
            fin = new FileInputStream(inFile);
            fout = new FileOutputStream(outFile);
            StringTools.copyStream(fin, fout);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        fin.close();
        fout.close();
        fTimeOut.setLastModified(lTimeIn);
        if (bRemoveSource && (bCanWrite = fTimeIn.canWrite())) {
            bDeleted = fTimeIn.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        InputStream inputStream = in;
        synchronized (inputStream) {
            OutputStream outputStream = out;
            synchronized (outputStream) {
                int bytesRead;
                byte[] buffer = new byte[256];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
    }

    public static boolean isLastThread(Thread thread) {
        int n = Thread.enumerate(new Thread[1]);
        return n > 0;
    }
}

