/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.tools.history;

import dk.kvl.alignmenttools.Alignment;
import dk.kvl.tools.history.HistoryItem;
import java.util.Enumeration;
import java.util.Hashtable;

public class UnpairBases
implements HistoryItem {
    private Hashtable historyData;
    private String[] sequences;

    public UnpairBases(String[] names, Hashtable data) {
        this.historyData = data;
        this.sequences = names;
    }

    public void undo(Alignment alignment) {
        for (int i = 0; i < this.sequences.length; ++i) {
            String name = this.sequences[i];
            int[][] data = (int[][])this.historyData.get(name);
            for (int j = 0; j < data.length; ++j) {
                alignment.getSequence(name).pairBases(data[j][0], data[j][1]);
            }
        }
    }

    public void redo(Alignment alignment) {
        Enumeration e = this.historyData.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            int[][] data = (int[][])this.historyData.get(key);
            for (int i = 0; i < data.length; ++i) {
                alignment.getSequence(key).unpair(data[i]);
            }
        }
    }

    public String getLabel() {
        return "Unpair bases";
    }
}

