/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.alignmenttools;

import dk.kvl.alignmenttools.Alignment;
import dk.kvl.alignmenttools.io.ColWriter;
import dk.kvl.gui.alignment.AlignmentContainer;
import dk.kvl.gui.alignment.AlignmentFrame;
import dk.kvl.gui.event.ProgramEvent;
import dk.kvl.gui.properties.AlignmentProperties;
import dk.kvl.gui.properties.ProjectProperties;
import dk.kvl.tools.Program;
import dk.kvl.tools.io.ErrorReaderThread;
import dk.kvl.tools.io.Log;
import dk.kvl.tools.io.StreamReaderThread;
import java.awt.Cursor;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Analyzer
extends Thread {
    private final Vector programs;
    private final Alignment alignment;
    private final AlignmentProperties properties;
    private ProjectProperties pProperties;
    private final String id;
    private BufferedWriter logWriter;
    private Log log;
    private File resultFile;
    private String projectName;
    private File finalResult;
    private ActionListener listener;
    private boolean error;
    private boolean pfold;
    private Program findphyl;

    public Analyzer(Vector selectedPrograms, Alignment alignment, AlignmentProperties props, ProjectProperties pProperties, ActionListener list, String project, String newId) {
        super(AlignmentFrame.sarseThreads, newId);
        this.programs = selectedPrograms;
        this.projectName = project;
        this.properties = props;
        this.pProperties = pProperties;
        this.alignment = alignment;
        this.schedulePrograms();
        this.id = newId;
        this.createLog();
        if (this.validProgramChain()) {
            this.listener = list;
            this.start();
        } else {
            JOptionPane.showMessageDialog(null, "Broken program chain, incompatible formats!");
        }
    }

    public String getAnalyzerId() {
        return this.id;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void run() {
        block21: {
            int counter = 1;
            try {
                this.finalResult = new File(this.pProperties.getPath() + "/result-" + this.id + ".col");
                Analyzer analyzer = this;
                String ppFile = analyzer.properties.getTmpDir() + "dotplot-" + this.id + ".pp";
                File dataFile = File.createTempFile("alignment-" + this.id, ".col", new File(this.pProperties.getPath()));
                this.resultFile = null;
                File ps = null;
                new ColWriter(dataFile, this.alignment, true, false);
                File originalFile = dataFile;
                Analyzer analyzer2 = this;
                this.resultFile = new File(analyzer2.properties.getTmpDir() + "/result-" + counter++ + "-" + this.id);
                if (this.resultFile.exists()) {
                    this.resultFile.delete();
                }
                for (int i = 0; i < this.programs.size(); ++i) {
                    Program p = (Program)this.programs.get(i);
                    if (p.getName().equals("cluster.tcsh")) {
                        File clusterFile = new File(this.pProperties.getPath() + "/clusterfiles" + this.id);
                        if (!clusterFile.exists()) {
                            clusterFile.mkdir();
                        }
                        clusterFile = new File(clusterFile + "/" + this.pProperties.getFile());
                        clusterFile.createNewFile();
                        new ColWriter(clusterFile, this.alignment, true, false);
                        p.execute(clusterFile, this.log);
                        clusterFile.renameTo(this.resultFile);
                        this.resultFile = clusterFile;
                    } else {
                        this.resultFile.createNewFile();
                        if (p.getName().equals("findphyl")) {
                            this.pfold = true;
                            this.findphyl = p;
                        }
                        p.execute(dataFile, this.resultFile, this.log, ppFile);
                    }
                    if (p.hasErrorMessage()) {
                        String progName = p.getName();
                        Object[] options = new String[]{"Yes", "No", "View log"};
                        int selected = JOptionPane.showOptionDialog(null, "An error occured executing " + progName + " which might cause your analysis to be corrupted.\n Refer to the log to view error messages. \n Do you want to continue?", "Warning", 0, 3, null, options, options[0]);
                        if (((String)options[selected]).equals("No")) {
                            throw new Exception("Execution aborted");
                        }
                        if (((String)options[selected]).equals("View log")) {
                            JTextArea jta = new JTextArea(this.log.readLog(), 10, 30);
                            JScrollPane jsp = new JScrollPane(jta);
                            jsp.setHorizontalScrollBarPolicy(32);
                            jsp.setVerticalScrollBarPolicy(22);
                            Object[] opts = new String[]{"Continue", "Stop execution"};
                            int ch = JOptionPane.showOptionDialog(null, jsp, "Log message", 0, 3, null, opts, opts[0]);
                            if (((String)opts[ch]).equals("Stop execution")) {
                                throw new Exception("Execution aborted");
                            }
                        }
                    }
                    Vector output = ((Program)this.programs.get(i)).getOutputTypes();
                    String pName = ((Program)this.programs.get(i)).getName();
                    if (i < this.programs.size() - 1) {
                        if (this.resultFile.length() == 0L) {
                            if (pName.equals("cluster.tcsh")) continue;
                            JOptionPane.showMessageDialog(null, "Error running " + p.getName() + ". Analysis aborted.");
                            this.removeFiles();
                            return;
                        }
                        if (((String)output.get(0)).equals("ps")) {
                            ps = new File(this.pProperties.getPath() + "/" + p.getName() + "-" + this.id + ".ps");
                            this.resultFile.renameTo(ps);
                            continue;
                        }
                        dataFile = this.resultFile;
                        Analyzer analyzer3 = this;
                        this.resultFile = new File(analyzer3.properties.getTmpDir() + "/result-" + counter++ + "-" + this.id);
                        continue;
                    }
                    if (this.resultFile.length() == 0L) {
                        if (p.getName().equals("cluster.tcsh")) {
                            JOptionPane.showMessageDialog(null, pName + " has finished \n Output files are placed here:\n " + this.pProperties.getPath() + "/clusterfiles" + this.id + "/");
                            return;
                        }
                        JOptionPane.showMessageDialog(null, "Error running " + p.getName() + ". Analysis aborted.");
                        this.removeFiles();
                        return;
                    }
                    if (((String)output.get(0)).equals("ps")) {
                        ps = new File(this.pProperties.getPath() + "/" + p.getName() + "-" + this.id + ".ps");
                        this.resultFile.renameTo(ps);
                        if (this.pfold) {
                            this.runParNum(dataFile, this.log);
                            continue;
                        }
                        dataFile.renameTo(this.finalResult);
                        continue;
                    }
                    if (this.pfold) {
                        this.runParNum(this.resultFile, this.log);
                        continue;
                    }
                    this.resultFile.renameTo(this.finalResult);
                }
                this.updateProjectFile();
                if (this.listener != null) {
                    ProgramEvent pe = new ProgramEvent(this, 0, this.finalResult.getName() + ", ID: " + this.id);
                    pe.setResultfile(this.finalResult.getName());
                    pe.addFiles(this.getFiles());
                    this.listener.actionPerformed(pe);
                }
            }
            catch (Exception e) {
                this.error = true;
                e.printStackTrace();
                if (this.listener == null) break block21;
                ProgramEvent pe = new ProgramEvent(this, 1, this.finalResult.getName() + ", ID: " + this.id);
                pe.setResultfile(this.finalResult.getName());
                pe.addFiles(this.getFiles());
                this.listener.actionPerformed(pe);
            }
        }
        this.removeFiles();
        ((AlignmentContainer)this.listener).setCursor(new Cursor(0));
        this.listener = null;
    }

    public File runDiscPmask(File dataFile, Log log) {
        File discmask = new File(this.pProperties.getPath() + "/discmask.col");
        try {
            if (discmask.exists()) {
                discmask.delete();
            }
            discmask.createNewFile();
            String[] cmds = new String[]{"discpmask", dataFile.getAbsolutePath()};
            Runtime runtime = Runtime.getRuntime();
            Process p = runtime.exec(cmds);
            log.writeLine("---------discpmask started---------------");
            BufferedReader resultReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedWriter resultWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(discmask)));
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            StreamReaderThread srt = new StreamReaderThread(resultReader, resultWriter);
            ErrorReaderThread ert = new ErrorReaderThread(errorReader, log, this.findphyl);
            srt.start();
            ert.start();
            p.waitFor();
            srt.join();
            ert.join();
            log.writeLine("--------- discpmask finished---------------");
            log.flush();
            resultWriter.flush();
            resultReader.close();
            resultWriter.close();
            errorReader.close();
            dataFile = discmask;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error removing pairingmask from file");
            e.printStackTrace();
        }
        return discmask;
    }

    public void runParNum(File dataFile, Log log) {
        try {
            ArrayList<String[]> allCmds = new ArrayList<String[]>();
            this.finalResult.createNewFile();
            String[] cmds = new String[]{"addpmasknum3", dataFile.getAbsolutePath()};
            allCmds.add(cmds);
            for (int i = 0; i < allCmds.size(); ++i) {
                String[] cmd = (String[])allCmds.get(i);
                String proName = cmd[0];
                log.writeLine("---------" + proName + " started---------------");
                Runtime runtime = Runtime.getRuntime();
                Process p = runtime.exec(cmd);
                BufferedReader resultReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedWriter resultWriter = null;
                resultWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.finalResult)));
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                StreamReaderThread srt = new StreamReaderThread(resultReader, resultWriter);
                ErrorReaderThread ert = new ErrorReaderThread(errorReader, log, this.findphyl);
                srt.start();
                ert.start();
                p.waitFor();
                srt.join();
                ert.join();
                log.writeLine("---------" + proName + " finished---------------");
                log.flush();
                resultWriter.flush();
                resultReader.close();
                resultWriter.close();
                errorReader.close();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "An error occurred running addp,masknum");
            e.printStackTrace();
        }
    }

    public void removeFiles() {
        Analyzer analyzer = this;
        File[] tmpFiles = new File(analyzer.properties.getTmpDir()).listFiles();
        for (int i = 0; i < tmpFiles.length; ++i) {
            tmpFiles[i].delete();
        }
    }

    public void schedulePrograms() {
        Collections.sort(this.programs);
    }

    public File getResultFile() {
        return this.resultFile;
    }

    protected boolean validProgramChain() {
        return true;
    }

    public void createLog() {
        try {
            File logFile;
            Analyzer analyzer = this;
            File logPath = new File(analyzer.properties.getLogDir());
            if (!logPath.exists()) {
                logPath.mkdir();
            }
            if (!(logFile = new File(logPath.getAbsolutePath() + "/log-" + this.id + ".log")).exists()) {
                logFile.createNewFile();
            }
            this.log = new Log(logFile, logPath);
            for (int i = 0; i < this.programs.size(); ++i) {
                StringBuffer cmdLine = new StringBuffer();
                Program p = (Program)this.programs.get(i);
                cmdLine.append(p.getName());
                for (int j = 0; j < p.getSelectedParameters().size(); ++j) {
                    cmdLine.append(" " + p.getSelectedParameters().get(j));
                }
                this.log.writeLine(cmdLine.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateProjectFile() {
        try {
            String path = this.pProperties.getPath();
            ProjectProperties prop = new ProjectProperties(this.projectName + ".prj");
            prop.setFile(this.finalResult.getName());
            prop.setPath(path);
            prop.store();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Vector getFiles() {
        Vector<Vector> files = new Vector<Vector>();
        for (int i = 0; i < this.programs.size(); ++i) {
            if (((Program)this.programs.get(i)).getFiles().size() <= 0) continue;
            files.add(((Program)this.programs.get(i)).getFiles());
        }
        return files;
    }
}

