/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.gui.alignment;

import dk.kvl.alignmenttools.Alignment;
import dk.kvl.alignmenttools.Analyzer;
import dk.kvl.controller.AlignmentController;
import dk.kvl.controller.AlignmentIOController;
import dk.kvl.gui.alignment.AlignmentControlPanel;
import dk.kvl.gui.alignment.AlignmentFrame;
import dk.kvl.gui.alignment.AlignmentPanel;
import dk.kvl.gui.alignment.SubalignmentSelector;
import dk.kvl.gui.components.AlignmentCanvas;
import dk.kvl.gui.components.AnalyzeFrame;
import dk.kvl.gui.components.HistoryPanel;
import dk.kvl.gui.event.ProgramEvent;
import dk.kvl.gui.event.UpdateEvent;
import dk.kvl.gui.event.UpdateListener;
import dk.kvl.gui.properties.AlignmentProperties;
import dk.kvl.gui.properties.ProjectProperties;
import dk.kvl.sequencetools.PairingMask;
import dk.kvl.tools.FileHistory;
import dk.kvl.tools.ReloadListener;
import dk.kvl.tools.history.ColFileHistoryItem;
import dk.kvl.tools.history.HistoryElement;
import dk.kvl.tools.io.ColFilter;
import dk.kvl.tools.io.TxtFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class AlignmentContainer
extends Container
implements ActionListener,
UpdateListener,
MouseListener,
ReloadListener {
    private JTabbedPane views = null;
    private AlignmentController controller = null;
    private AlignmentControlPanel controlPanel = null;
    private AlignmentProperties properties = null;
    private String alignmentName;
    private String alignmentFileName;
    private String projectDir;
    private String[] recentProjects;
    private AnalyzeFrame analyzeFrame;
    private ProjectProperties projectProperties;
    private AlignmentCanvas overview = null;
    private JFrame canvasWindow;
    private int overviewX = 50;
    private int overviewY = 50;
    private JFrame historyWindow;
    private int historyX = 100;
    private int historyY = 100;
    private JFrame infoFrame;
    private FileHistory fileHist;
    private boolean horizontalSplit;
    private boolean splitMode;
    private boolean historyEnabled;
    private boolean prevHistoryEnabled;
    private Point p1;
    private Point p2;
    private Point p3;
    private boolean selectionMode;
    private boolean splitAlign;
    private boolean newHistory;
    private int operationMode;
    private int divider;
    private File file;
    private final AlignmentFrame parent;

    public AlignmentContainer(AlignmentFrame frame, File file, String aname, boolean selectionMode, int operationMode, boolean splitMode, boolean splitAlign, Point p1, Point p2, Point p3, int divider, String projectDir, AlignmentProperties properties) throws Exception, IOException, FileNotFoundException {
        FileHistory fileHist;
        this.parent = frame;
        this.alignmentName = aname;
        this.alignmentFileName = file.getAbsolutePath();
        this.file = file;
        this.projectDir = projectDir;
        this.setLayout(new BorderLayout());
        this.controller = new AlignmentController(file, aname, projectDir);
        this.controller.addUpdateListener(this);
        this.controller.addReloadListener(this);
        this.properties = properties;
        this.views = new JTabbedPane();
        this.add("Center", this.views);
        this.selectionMode = selectionMode;
        this.operationMode = operationMode;
        this.splitMode = splitMode;
        this.splitAlign = splitAlign;
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
        this.divider = divider;
        this.addControlPanel(this.controller.getColumnLabels());
        if (this.projectProperties == null) {
            this.projectProperties = new ProjectProperties(this.alignmentName, file.getName(), projectDir);
            this.projectProperties.store();
        }
        if ((fileHist = AlignmentIOController.loadHistory(projectDir)) != null) {
            this.controller.setFileHistory(fileHist);
        } else {
            this.newHistory = true;
            fileHist = new FileHistory(projectDir);
            this.controller.setFileHistory(fileHist);
        }
        if (file.getName().endsWith(".widetxt") || file.getName().endsWith(".txt") || file.getName().endsWith(".fasta")) {
            String[] split = file.getName().split("\\.");
            if (this.newHistory) {
                ColFileHistoryItem fhi = new ColFileHistoryItem(this.controller.getMainAlignment(), this.projectProperties.getPath(), split[0] + ".col");
                fhi.setHistory();
                this.controller.addFileHistoryItem(fhi);
                this.newHistory = false;
            } else {
                this.controller.addFileHistoryItem(new ColFileHistoryItem(this.controller.getMainAlignment(), this.projectProperties.getPath(), split[0] + ".col"));
            }
            this.projectProperties.setFile(split[0] + ".col");
            this.controller.setFileName(split[0] + ".col");
            this.controller.setHistory(fileHist.get(split[0] + ".col").getHistory());
            fileHist.get(split[0] + ".col").getHistory().setAlignment(this.controller.getMainAlignment());
            if (properties.createMainViewFromBeginning()) {
                this.addView(split[0] + ".col");
            }
        } else {
            if (this.newHistory) {
                ColFileHistoryItem fhi = new ColFileHistoryItem(this.controller.getMainAlignment(), this.projectProperties.getPath(), file.getName());
                fhi.setHistory();
                fileHist.add(fhi);
                this.newHistory = false;
            } else {
                fileHist.add(new ColFileHistoryItem(this.controller.getMainAlignment(), this.projectProperties.getPath(), file.getName()));
            }
            this.controller.setHistory(fileHist.get(file.getName()).getHistory());
            fileHist.get(file.getName()).getHistory().setAlignment(this.controller.getMainAlignment());
            this.controller.setFileName(file.getName());
            if (properties.createMainViewFromBeginning()) {
                this.addView(file.getName());
            }
        }
    }

    public AlignmentController getAlignmentController() {
        return this.controller;
    }

    public void setOverviewEnabled(boolean enabled) {
    }

    public void addControlPanel(String[] columnLabels) {
        this.controlPanel = new AlignmentControlPanel(this.properties, columnLabels);
        this.controlPanel.addActionListener(this);
        this.controlPanel.enableSplitButtons(this.splitMode);
        this.add("West", this.controlPanel);
    }

    public AlignmentControlPanel getControlPanel() {
        return this.controlPanel;
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        String name = "";
        if (ae.getSource() instanceof JButton) {
            name = ((JButton)ae.getSource()).getAccessibleContext().getAccessibleName();
        } else if (ae.getSource() instanceof JCheckBox) {
            name = ((JCheckBox)ae.getSource()).getAccessibleContext().getAccessibleName();
        }
        if (cmd.equals("Subalignment")) {
            this.subalignment();
        } else if (cmd.equals("Clear selection")) {
            ((AlignmentPanel)this.views.getSelectedComponent()).clearSelections();
        } else if (name.equals("split")) {
            this.split();
        } else if (name.equals("uppercase")) {
            this.toUpperCase();
        } else if (name.equals("unpair bases")) {
            this.unpairBases();
        } else if (name.equals("rotate left")) {
            this.rotateRight();
        } else if (name.equals("rotate right")) {
            this.rotateLeft();
        } else if (name.equals("change")) {
            this.change();
        } else if (name.equals("unsplit")) {
            this.unsplit();
        } else if (ae.getSource() instanceof Analyzer) {
            this.changeMainAlignment(ae);
        } else if (name.equals("close_history")) {
            this.setHistoryEnabled(false);
        } else if (name.startsWith("Show")) {
            JCheckBox cb = (JCheckBox)ae.getSource();
            String column = cb.getText().substring(cb.getText().lastIndexOf(" ") + 1, cb.getText().length());
        } else if (name.equals("Pair bases")) {
            this.pairBases();
        } else if (name.equals("Pair columns")) {
            this.pairColumns();
        } else if (name.equals("single")) {
            this.selectionMode(true);
        } else if (name.equals("double")) {
            this.selectionMode(false);
        }
    }

    public void pairColumns() {
        int[] cols = this.getSelectedProject().getSelectedColumns();
        String input = null;
        if (cols.length % 2 == 0) {
            char mask = '\u0000';
            while (mask == '\u0000' && (input = JOptionPane.showInputDialog("Write the character you want to use in the pairingmask:")) != null && input.length() != 0) {
                if (input.length() <= 0) continue;
                mask = input.charAt(0);
            }
            if (mask != '\u0000' && Character.isLetterOrDigit(mask)) {
                for (int i = 0; i < cols.length / 2; ++i) {
                    if (this.controller.getPairing(this.controller.getPairingmaskName(), cols[i]) == -1 && this.controller.getPairing(this.controller.getPairingmaskName(), cols[cols.length - 1 - i]) == -1) {
                        ArrayList<HistoryElement> elements = new ArrayList<HistoryElement>();
                        elements.add(new HistoryElement(cols[i], cols[cols.length - 1 - i], mask));
                        this.controller.pairColumns(elements);
                        continue;
                    }
                    JOptionPane.showMessageDialog(null, "One or both of the columns " + (cols[i] + 1) + ", " + (cols[cols.length - 1 - i] + 1) + " allready pairs and is not changed");
                }
            } else if (input != null) {
                JOptionPane.showMessageDialog(null, "You must write a letter or a digit");
            }
        } else {
            JOptionPane.showMessageDialog(null, "You must select an equal number af columns!");
        }
    }

    public void changeMainAlignment(ActionEvent ae) {
        int res = -1;
        String cmd = ae.getActionCommand();
        if (ae.getID() == 0) {
            try {
                String optStr = "resultfile: " + cmd + " has finished.\nDo you want to load it?\n";
                if (((ProgramEvent)ae).getFiles().size() > 0) {
                    optStr = optStr + "Additional files where created:\n";
                    for (int i = 0; i < ((ProgramEvent)ae).getFiles().size(); ++i) {
                        optStr = optStr + ((ProgramEvent)ae).getFiles().get(i) + "\n";
                    }
                    optStr = optStr + "The files are placed in: " + ((ProgramEvent)ae).getResultfile();
                }
                res = JOptionPane.showConfirmDialog(null, optStr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (res == 0) {
                try {
                    this.controller.addFileHistoryItem(new ColFileHistoryItem(this.controller.getMainAlignment(), this.projectProperties.getPath(), ((ProgramEvent)ae).getResultfile()));
                    this.controller.setMainAlignmentFromFile(this.projectProperties.getPath() + "/" + ((ProgramEvent)ae).getResultfile());
                    this.validate();
                    this.repaint();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                JOptionPane.showMessageDialog(null, "The result file is named: result-" + cmd);
            }
        } else if (ae.getID() == 3) {
            res = JOptionPane.showConfirmDialog(null, "Do you wish to launch gv to view: " + cmd + "?");
            if (res == 0) {
                Runtime runtime = Runtime.getRuntime();
                String[] cmds = new String[]{"gv", cmd};
                try {
                    Process p = runtime.exec(cmds);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "An error occurred while running gv");
                }
            }
        } else {
            JOptionPane.showMessageDialog(null, "An error occurred in processing id:" + cmd);
        }
        this.analyzeFrame = null;
    }

    public void close() {
        if (this.canvasWindow != null) {
            this.setOverviewEnabled(false);
        }
        if (this.historyWindow != null) {
            this.prevHistoryEnabled = this.historyEnabled;
            this.setHistoryEnabled(false);
        }
        if (this.infoFrame != null) {
            this.infoFrame.dispose();
            this.infoFrame = null;
        }
        String name = this.getSelectedName();
        this.checkView(name);
        this.views.remove((AlignmentPanel)this.views.getSelectedComponent());
        if (this.views.getTabCount() > 0) {
            this.views.setSelectedIndex(0);
        } else {
            this.views.setSelectedIndex(-1);
        }
    }

    public void split() {
        this.splitMode = true;
        ((AlignmentPanel)this.views.getSelectedComponent()).split();
    }

    public void unsplit() {
        this.splitMode = false;
        ((AlignmentPanel)this.views.getSelectedComponent()).unsplit();
    }

    public void change() {
        if (this.views.getSelectedComponent() != null) {
            int[] selectedColumns = null;
            int[] selectedRows = null;
            ArrayList<HistoryElement> elements = new ArrayList<HistoryElement>();
            if (this.operationMode == 1) {
                selectedColumns = ((AlignmentPanel)this.views.getSelectedComponent()).getSelectedColumns();
                selectedRows = ((AlignmentPanel)this.views.getSelectedComponent()).getSelectedRows();
                String[] seqs = new String[selectedRows.length];
                String pMask = null;
                for (int i = 0; i < selectedRows.length; ++i) {
                    String name = this.getSelectedProject().getSequenceName(selectedRows[i]);
                    if (this.controller.isPairingMask(name)) {
                        pMask = name;
                        continue;
                    }
                    seqs[i] = name;
                }
                if (pMask != null) {
                    String symbol = JOptionPane.showInputDialog(null, (Object)"What symbol do you want to use?");
                    if (symbol != null && symbol.length() >= 1) {
                        String[] mask = new String[]{pMask};
                        elements.add(new HistoryElement(mask, selectedColumns, symbol.charAt(0)));
                        this.controller.changeSymbols(elements);
                    } else {
                        JOptionPane.showMessageDialog(null, "Only 1 character in the symbol");
                    }
                } else if (seqs.length > 0) {
                    char[] symbols = this.controller.getAlphabet();
                    Object[] alphabet = new String[symbols.length];
                    for (int i = 0; i < symbols.length; ++i) {
                        alphabet[i] = "" + symbols[i];
                    }
                    String ch = (String)JOptionPane.showInputDialog(null, "What character do you want to insert?", "Select character", -1, null, alphabet, null);
                    if (ch != null && ch.length() == 1) {
                        elements.add(new HistoryElement(seqs, selectedColumns, ch.charAt(0)));
                        this.controller.changeSymbols(elements);
                    }
                }
            } else if (this.operationMode == 2) {
                selectedColumns = ((AlignmentPanel)this.views.getSelectedComponent()).getSelectedColumns();
                selectedRows = ((AlignmentPanel)this.views.getSelectedComponent()).getSelectedRows();
                String[] seqs = new String[selectedRows.length];
                String pMask = null;
                for (int i = 0; i < selectedRows.length; ++i) {
                    String name = this.getSelectedProject().getSequenceName(selectedRows[i]);
                    if (this.controller.isPairingMask(name)) {
                        pMask = name;
                        continue;
                    }
                    seqs[i] = name;
                }
                if (pMask != null) {
                    String symbol = JOptionPane.showInputDialog(null, (Object)"What symbol do you want to use?");
                    if (symbol != null && symbol.length() >= 1) {
                        String[] mask = new String[]{pMask};
                        elements.add(new HistoryElement(mask, selectedColumns, symbol.charAt(0)));
                        this.controller.changeSymbols(elements);
                    } else {
                        JOptionPane.showMessageDialog(null, "Only 1 character in the symbol");
                    }
                } else if (seqs.length > 0) {
                    char[] symbols = this.controller.getAlphabet();
                    Object[] alphabet = new String[symbols.length];
                    for (int i = 0; i < symbols.length; ++i) {
                        alphabet[i] = "" + symbols[i];
                    }
                    String ch = (String)JOptionPane.showInputDialog(null, "What character do you want to insert?", "Select character", -1, null, alphabet, null);
                    if (ch.length() == 1) {
                        elements.add(new HistoryElement(seqs, selectedColumns, ch.charAt(0)));
                        this.controller.changeSymbols(elements);
                    }
                }
            } else {
                selectedColumns = ((AlignmentPanel)this.views.getSelectedComponent()).getSelectedColumns();
                selectedRows = ((AlignmentPanel)this.views.getSelectedComponent()).getSelectedRows();
                String[] seqs = new String[selectedRows.length];
                String pMask = null;
                for (int i = 0; i < selectedRows.length; ++i) {
                    String name = this.getSelectedProject().getSequenceName(selectedRows[i]);
                    if (this.controller.isPairingMask(name)) {
                        pMask = name;
                        continue;
                    }
                    seqs[i] = name;
                }
                if (pMask != null) {
                    String symbol = JOptionPane.showInputDialog(null, (Object)"What symbol do you want to use?");
                    if (symbol.length() >= 1) {
                        String[] mask = new String[]{pMask};
                        elements.add(new HistoryElement(mask, selectedColumns, symbol.charAt(0)));
                        this.controller.changeSymbols(elements);
                    } else {
                        JOptionPane.showMessageDialog(null, "Only 1 character in the symbol");
                    }
                } else if (seqs.length > 0) {
                    char[] symbols = this.controller.getAlphabet();
                    Object[] alphabet = new String[symbols.length];
                    for (int i = 0; i < symbols.length; ++i) {
                        alphabet[i] = "" + symbols[i];
                    }
                    String ch = (String)JOptionPane.showInputDialog(null, "What character do you want to insert?", "Select character", -1, null, alphabet, null);
                    if (ch.length() == 1) {
                        elements.add(new HistoryElement(seqs, selectedColumns, ch.charAt(0)));
                        this.controller.changeSymbols(elements);
                    }
                }
            }
        }
    }

    public void toLowerCase() {
        if (this.views.getSelectedComponent() != null) {
            if (!((AlignmentPanel)this.views.getSelectedComponent()).isSplit()) {
                String name = this.getSelectedName();
                int[] selectedColumns = ((AlignmentPanel)this.views.getSelectedComponent()).getSelectedColumns();
                int[] selectedRows = ((AlignmentPanel)this.views.getSelectedComponent()).getSelectedRows();
                if (selectedColumns.length > 0) {
                    Vector v = this.getSequenceNames(selectedRows);
                    ArrayList<HistoryElement> elements = new ArrayList<HistoryElement>();
                    elements.add(new HistoryElement(v.toArray(new String[0]), selectedColumns));
                    this.controller.toLowerCase(elements);
                }
            } else {
                this.toLowerCaseSplit();
            }
        } else {
            JOptionPane.showMessageDialog(this, "You need to create or open a project before changing cases");
        }
    }

    public void toLowerCaseSplit() {
        String name = this.getSelectedName();
        int[] selectedColumns = null;
        int[] selectedRows = null;
        ArrayList<HistoryElement> elements = new ArrayList<HistoryElement>();
        if (this.operationMode == 1) {
            selectedColumns = ((AlignmentPanel)this.views.getSelectedComponent()).getLeftSelectedColumns();
            selectedRows = ((AlignmentPanel)this.views.getSelectedComponent()).getLeftSelectedRows();
            if (selectedColumns.length > 0) {
                Vector v = this.getSequenceNames(selectedRows);
                elements.add(new HistoryElement(v.toArray(new String[0]), selectedColumns));
                this.controller.toLowerCase(elements);
            }
        } else if (this.operationMode == 2) {
            selectedColumns = ((AlignmentPanel)this.views.getSelectedComponent()).getRightSelectedColumns();
            selectedRows = ((AlignmentPanel)this.views.getSelectedComponent()).getRightSelectedRows();
            if (selectedColumns.length > 0) {
                Vector v = this.getSequenceNames(selectedRows);
                elements.add(new HistoryElement(v.toArray(new String[0]), selectedColumns));
                this.controller.toLowerCase(elements);
            }
        } else {
            Vector v;
            selectedColumns = ((AlignmentPanel)this.views.getSelectedComponent()).getLeftSelectedColumns();
            selectedRows = ((AlignmentPanel)this.views.getSelectedComponent()).getLeftSelectedRows();
            if (selectedColumns.length > 0) {
                v = this.getSequenceNames(selectedRows);
                elements.add(new HistoryElement(v.toArray(new String[0]), selectedColumns));
            }
            selectedColumns = ((AlignmentPanel)this.views.getSelectedComponent()).getRightSelectedColumns();
            selectedRows = ((AlignmentPanel)this.views.getSelectedComponent()).getRightSelectedRows();
            if (selectedColumns.length > 0) {
                v = this.getSequenceNames(selectedRows);
                elements.add(new HistoryElement(v.toArray(new String[0]), selectedColumns));
            }
            this.controller.toLowerCase(elements);
        }
    }

    public void addView(String name) throws Exception {
        try {
            this.setHistoryEnabled(this.prevHistoryEnabled);
            AlignmentPanel aPanel = new AlignmentPanel(this.controller, this.properties, name);
            if (this.splitMode && this.p2 != null && this.p3 != null && this.divider > 0) {
                aPanel.split();
                aPanel.setSplitAlign(this.splitAlign);
                aPanel.getTableView2().getViewport().setViewPosition(this.p2);
                aPanel.getTableView3().getViewport().setViewPosition(this.p3);
                aPanel.getSplitPane().setDividerLocation(this.divider);
            } else if (this.p1 != null) {
                aPanel.getTableView().getViewport().setViewPosition(this.p1);
            }
            aPanel.selectionMode(this.selectionMode);
            aPanel.operationMode(this.operationMode);
            this.views.addTab(name, aPanel);
            this.views.setSelectedComponent(aPanel);
            if (this.overview == null) {
                this.setOverviewEnabled(this.parent.isOverviewEnabled());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Couldn't create view");
            throw e;
        }
    }

    public void updatePerformed(UpdateEvent ue) {
        if (this.views.getTabCount() > 0) {
            if (this.controller.isChanged(this.getSelectedName())) {
                this.views.setTitleAt(this.views.getSelectedIndex(), "*" + this.getSelectedName());
            } else {
                this.views.setTitleAt(this.views.getSelectedIndex(), this.getSelectedName());
            }
        }
        if (this.controller.isChanged()) {
            // empty if block
        }
        this.repaint();
    }

    public void toUpperCase() {
        if (this.views.getSelectedComponent() != null) {
            String name = this.getSelectedName();
            if (!((AlignmentPanel)this.views.getSelectedComponent()).isSplit()) {
                int[] selectedColumns = ((AlignmentPanel)this.views.getSelectedComponent()).getSelectedColumns();
                int[] selectedRows = ((AlignmentPanel)this.views.getSelectedComponent()).getSelectedRows();
                Vector v = this.getSequenceNames(selectedRows);
                ArrayList<HistoryElement> elements = new ArrayList<HistoryElement>();
                elements.add(new HistoryElement(v.toArray(new String[0]), selectedColumns));
                this.controller.toUpperCase(elements);
            } else {
                this.toUpperCaseSplit();
            }
        }
    }

    public void toUpperCaseSplit() {
        String name = this.getSelectedName();
        int[] selectedColumns = null;
        int[] selectedRows = null;
        Vector v = new Vector();
        ArrayList<HistoryElement> elements = new ArrayList<HistoryElement>();
        if (this.operationMode == 1) {
            selectedColumns = ((AlignmentPanel)this.views.getSelectedComponent()).getLeftSelectedColumns();
            selectedRows = ((AlignmentPanel)this.views.getSelectedComponent()).getLeftSelectedRows();
            v = this.getSequenceNames(selectedRows);
            elements.add(new HistoryElement(v.toArray(new String[0]), selectedColumns));
            this.controller.toUpperCase(elements);
        } else if (this.operationMode == 2) {
            selectedColumns = ((AlignmentPanel)this.views.getSelectedComponent()).getRightSelectedColumns();
            selectedRows = ((AlignmentPanel)this.views.getSelectedComponent()).getRightSelectedRows();
            v = this.getSequenceNames(selectedRows);
            elements.add(new HistoryElement(v.toArray(new String[0]), selectedColumns));
            this.controller.toUpperCase(elements);
        } else {
            selectedColumns = ((AlignmentPanel)this.views.getSelectedComponent()).getLeftSelectedColumns();
            selectedRows = ((AlignmentPanel)this.views.getSelectedComponent()).getLeftSelectedRows();
            v = this.getSequenceNames(selectedRows);
            elements.add(new HistoryElement(v.toArray(new String[0]), selectedColumns));
            selectedColumns = ((AlignmentPanel)this.views.getSelectedComponent()).getRightSelectedColumns();
            selectedRows = ((AlignmentPanel)this.views.getSelectedComponent()).getRightSelectedRows();
            v = this.getSequenceNames(selectedRows);
            elements.add(new HistoryElement(v.toArray(new String[0]), selectedColumns));
            this.controller.toUpperCase(elements);
        }
    }

    public int[] getSelectedColumns() {
        int[] selectedColumns = null;
        if (this.views.getSelectedComponent() != null) {
            if (!((AlignmentPanel)this.views.getSelectedComponent()).isSplit()) {
                selectedColumns = ((AlignmentPanel)this.views.getSelectedComponent()).getSelectedColumns();
            } else {
                int[] rightselectedColumns = ((AlignmentPanel)this.views.getSelectedComponent()).getRightSelectedColumns();
                int[] nArray = ((AlignmentPanel)this.views.getSelectedComponent()).getRightSelectedColumns();
            }
        }
        return selectedColumns;
    }

    public void subalignment() {
        AlignmentPanel selected = this.getSelectedProject();
        Enumeration e = this.controller.getSequenceKeys();
        String[] selNames = new String[]{};
        int start = 1;
        int end = this.controller.getAlignmentLength();
        if (selected != null) {
            int[] selectedColumns = selected.getSelectedColumns();
            if (selectedColumns != null && selectedColumns.length >= 2) {
                start = selected.getColumnNumber(selectedColumns[0]);
                end = selected.getColumnNumber(selectedColumns[selectedColumns.length - 1]);
            }
            selNames = selected.getSelectedNames().toArray(new String[0]);
        }
        SubalignmentSelector.showSubalignmentSelector(selNames, this.controller.getSortedNames(), start, end, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SubalignmentSelector selector = (SubalignmentSelector)ae.getSource();
                String name = selector.getName();
                int start = selector.getStart();
                int end = selector.getEnd();
                Vector names = selector.getSelected();
                if (names.size() > 0 && name != null) {
                    try {
                        AlignmentContainer.this.addView(name);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                selector.dispose();
            }
        });
    }

    public Vector getSequenceNames(int[] names) {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < names.length; ++i) {
            v.add(((AlignmentPanel)this.views.getSelectedComponent()).getSequenceName(names[i]));
        }
        return v;
    }

    public String getSelectedName() {
        return ((AlignmentPanel)this.views.getSelectedComponent()).getAlignmentName();
    }

    public void saveAs() {
        File workDir = new File(this.projectProperties.getPath() + "/");
        if (!workDir.exists()) {
            workDir.mkdirs();
        }
        JFileChooser chooser = new JFileChooser(workDir);
        int choice = chooser.showSaveDialog(null);
        if (choice == 0) {
            File f = chooser.getSelectedFile();
            this.saveAs(f);
            this.alignmentFileName = f.getName();
        }
    }

    public void export() {
        AlignmentIOController.export(this.controller.getMainAlignment(), this.projectProperties);
    }

    public void saveAs(File file) {
        this.alignmentFileName = this.controller.saveAlignment(file);
        try {
            AlignmentIOController.saveHistory(this.controller.getFileHistory(), this.projectProperties.getPath());
            this.projectProperties.setFile(this.alignmentFileName.substring(this.alignmentFileName.lastIndexOf(47) + 1, this.alignmentFileName.length()));
            this.projectProperties.store();
            this.storeProperties();
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "couldn't save property file");
        }
    }

    public void saveAs(String fileName) {
        this.saveAs(new File(fileName));
    }

    public void save() {
        if (this.alignmentFileName == null || this.alignmentFileName.equals("")) {
            this.saveAs();
        } else {
            this.saveAs(this.projectProperties.getPath() + "/" + this.projectProperties.getFile());
        }
    }

    public boolean isSplitMode() {
        if (this.getSelectedProject() != null) {
            return this.getSelectedProject().isSplit();
        }
        return false;
    }

    public AlignmentPanel getSelectedProject() {
        return (AlignmentPanel)this.views.getSelectedComponent();
    }

    public void analyze() {
        AlignmentContainer parent = this;
        this.setCursor(new Cursor(3));
        this.checkAllViews();
        this.save();
        try {
            this.analyzeFrame = new AnalyzeFrame(this.properties, this.projectProperties, this.controller.getMainAlignment(), parent, this.projectProperties.getName());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(parent, "Error message: " + e.getMessage(), "Error", 2);
        }
    }

    public void createInfoPanel() {
    }

    public boolean isAnalyzing() {
        return this.analyzeFrame != null;
    }

    public void rotateLeft() {
        ArrayList<HistoryElement> elements = new ArrayList<HistoryElement>();
        if (this.getSelectedProject().isSplit()) {
            int[] columns = null;
            if (this.operationMode == 1) {
                columns = this.getSelectedProject().getLeftSelectedColumns();
                if (columns.length > 1) {
                    int[] rows = this.getSelectedProject().getLeftSelectedRows();
                    String[] seqs = new String[rows.length];
                    for (int i = 0; i < rows.length; ++i) {
                        seqs[i] = this.getSelectedProject().getSequenceName(rows[i]);
                    }
                    elements.add(new HistoryElement(seqs, columns[0], columns[columns.length - 1]));
                    this.controller.rotateLeft(elements);
                }
            } else if (this.operationMode == 2) {
                if (!this.selectionMode && (columns = this.getSelectedProject().getRightSelectedColumns()).length > 1) {
                    int[] rows = this.getSelectedProject().getRightSelectedRows();
                    String[] seqs = new String[rows.length];
                    for (int i = 0; i < rows.length; ++i) {
                        seqs[i] = this.getSelectedProject().getSequenceName(rows[i]);
                    }
                    elements.add(new HistoryElement(seqs, columns[0], columns[columns.length - 1]));
                    this.controller.rotateLeft(elements);
                }
            } else if (!this.selectionMode) {
                int i;
                String[] seqs;
                int[] rows;
                columns = this.getSelectedProject().getLeftSelectedColumns();
                if (columns.length > 1) {
                    rows = this.getSelectedProject().getLeftSelectedRows();
                    seqs = new String[rows.length];
                    for (i = 0; i < rows.length; ++i) {
                        seqs[i] = this.getSelectedProject().getSequenceName(rows[i]);
                    }
                    elements.add(new HistoryElement(seqs, columns[0], columns[columns.length - 1]));
                }
                if ((columns = this.getSelectedProject().getRightSelectedColumns()).length > 1) {
                    rows = this.getSelectedProject().getRightSelectedRows();
                    seqs = new String[rows.length];
                    for (i = 0; i < rows.length; ++i) {
                        seqs[i] = this.getSelectedProject().getSequenceName(rows[i]);
                    }
                    elements.add(new HistoryElement(seqs, columns[0], columns[columns.length - 1]));
                }
                this.controller.rotateLeft(elements);
            }
        } else if (this.selectionMode) {
            int[] columns = this.getSelectedProject().getSelectedColumns();
            if (columns.length > 1) {
                int[] rows = this.getSelectedProject().getSelectedRows();
                String[] seqs = new String[rows.length];
                for (int i = 0; i < rows.length; ++i) {
                    seqs[i] = this.getSelectedProject().getSequenceName(rows[i]);
                }
                elements.add(new HistoryElement(seqs, columns[0], columns[columns.length - 1]));
                this.controller.rotateLeft(elements);
            } else {
                JOptionPane.showMessageDialog(null, "No columns selected!");
            }
        } else {
            this.showMoveWarning();
        }
    }

    protected void showMoveWarning() {
        JOptionPane.showMessageDialog(this, "Move left/right works only in Single Select mode");
    }

    public void rotateRight() {
        ArrayList<HistoryElement> elements = new ArrayList<HistoryElement>();
        if (this.getSelectedProject().isSplit()) {
            int[] columns = null;
            if (this.operationMode == 1) {
                columns = this.getSelectedProject().getLeftSelectedColumns();
                if (columns.length > 1) {
                    int[] rows = this.getSelectedProject().getLeftSelectedRows();
                    String[] seqs = new String[rows.length];
                    for (int i = 0; i < rows.length; ++i) {
                        seqs[i] = this.getSelectedProject().getSequenceName(rows[i]);
                    }
                    elements.add(new HistoryElement(seqs, columns[0], columns[columns.length - 1]));
                    this.controller.rotateRight(elements);
                }
            } else if (this.operationMode == 2) {
                if (!this.selectionMode && (columns = this.getSelectedProject().getRightSelectedColumns()).length > 1) {
                    int[] rows = this.getSelectedProject().getRightSelectedRows();
                    String[] seqs = new String[rows.length];
                    for (int i = 0; i < rows.length; ++i) {
                        seqs[i] = this.getSelectedProject().getSequenceName(rows[i]);
                    }
                    elements.add(new HistoryElement(seqs, columns[0], columns[columns.length - 1]));
                    this.controller.rotateRight(elements);
                }
            } else {
                if (!this.selectionMode) {
                    int i;
                    String[] seqs;
                    int[] rows;
                    columns = this.getSelectedProject().getLeftSelectedColumns();
                    if (columns.length > 1) {
                        rows = this.getSelectedProject().getLeftSelectedRows();
                        seqs = new String[rows.length];
                        for (i = 0; i < rows.length; ++i) {
                            seqs[i] = this.getSelectedProject().getSequenceName(rows[i]);
                        }
                        elements.add(new HistoryElement(seqs, columns[0], columns[columns.length - 1]));
                    }
                    if ((columns = this.getSelectedProject().getRightSelectedColumns()).length > 1) {
                        rows = this.getSelectedProject().getRightSelectedRows();
                        seqs = new String[rows.length];
                        for (i = 0; i < rows.length; ++i) {
                            seqs[i] = this.getSelectedProject().getSequenceName(rows[i]);
                        }
                        elements.add(new HistoryElement(seqs, columns[0], columns[columns.length - 1]));
                    }
                }
                this.controller.rotateRight(elements);
            }
        } else if (this.selectionMode) {
            int[] columns = this.getSelectedProject().getSelectedColumns();
            if (columns.length > 1) {
                int[] rows = this.getSelectedProject().getSelectedRows();
                String[] seqs = new String[rows.length];
                for (int i = 0; i < rows.length; ++i) {
                    seqs[i] = this.getSelectedProject().getSequenceName(rows[i]);
                }
                elements.add(new HistoryElement(seqs, columns[0], columns[columns.length - 1]));
                this.controller.rotateRight(elements);
            } else {
                JOptionPane.showMessageDialog(null, "No columns selected!");
            }
        } else {
            this.showMoveWarning();
        }
    }

    public void setTraceEnabled(boolean value) {
        Component[] children = this.views.getComponents();
        for (int i = 0; i < children.length; ++i) {
            ((AlignmentPanel)this.views.getComponent(i)).setTraceEnabled(value);
        }
    }

    public void setProjectDir(String dir) {
        this.projectDir = dir;
        this.projectProperties.setPath(this.projectDir);
    }

    public void clear() {
        ((AlignmentPanel)this.views.getSelectedComponent()).clearSelections();
    }

    public void jump() {
        String number = JOptionPane.showInputDialog("Which column will you go to");
        try {
            int num = Integer.parseInt(number);
            this.getSelectedProject().centerTable(num - 1, -1);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(null, "Not a number!");
        }
    }

    public void closeAll() {
        while (this.views.getTabCount() > 0) {
            this.close();
        }
    }

    public void checkView(String name) {
        int i;
        if (this.controller.getMainAlignment() != null && this.controller.isChanged() && (i = JOptionPane.showConfirmDialog(null, "There is uncommited changes to: " + name + ".\n\nDo you want to save them?")) == 0) {
            this.save();
        }
    }

    public void checkAllViews() {
        for (int i = 0; i < this.views.getTabCount(); ++i) {
            this.checkView(this.views.getTitleAt(i));
        }
    }

    public void cleanup() {
        this.closeAll();
        if (this.analyzeFrame != null) {
            this.analyzeFrame.removeActionListener();
            this.analyzeFrame = null;
        }
    }

    public void setBasecoloringEnabled(boolean enabled) {
        this.properties.setBaseColoring(enabled);
    }

    public void mouseClicked(MouseEvent me) {
        if (me.getX() <= this.controller.getAlignmentLength() && me.getY() < this.controller.getNumberOfSequences()) {
            this.getSelectedProject().centerCell(me.getX(), me.getY());
        }
        me.consume();
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void setHistoryEnabled(boolean enabled) {
        this.historyEnabled = enabled;
    }

    public HistoryPanel getHistoryPanel() {
        HistoryPanel hPanel = new HistoryPanel(this.controller, this, this.properties);
        hPanel.addReloadListener(this);
        return hPanel;
    }

    public void paint(Graphics g) {
        if (this.historyWindow != null) {
            this.historyWindow.repaint();
        }
        super.paint(g);
    }

    public int getPairing(int index) {
        int[] selectedRows = ((AlignmentPanel)this.views.getSelectedComponent()).getSelectedRows();
        if (selectedRows.length > 0) {
            String name = this.getSelectedProject().getSequenceName(selectedRows[0]);
            return this.controller.getPairing(name, index);
        }
        return -1;
    }

    public String getSelectedSequence() {
        int[] selectedRows = ((AlignmentPanel)this.views.getSelectedComponent()).getSelectedRows();
        if (selectedRows.length > 0) {
            return this.getSelectedProject().getSequenceName(selectedRows[0]);
        }
        return null;
    }

    public String[] getSelectedSequences() {
        int[] selectedRows = ((AlignmentPanel)this.views.getSelectedComponent()).getSelectedNameRows();
        String[] deleteRows = null;
        if (selectedRows != null && selectedRows.length > 0) {
            deleteRows = new String[selectedRows.length];
            for (int i = 0; i < selectedRows.length; ++i) {
                deleteRows[i] = this.getSelectedProject().getSequenceName(selectedRows[i]);
            }
        }
        return deleteRows;
    }

    public void removeGaps() {
        int removed = this.controller.removeGaps();
    }

    public void removeColumn() {
        String res = JOptionPane.showInputDialog(null, (Object)"What column do you want to remove");
        if (res != null) {
            try {
                int col = Integer.parseInt(res);
                if (col > 0 && col <= this.controller.getAlignmentLength()) {
                    ArrayList<HistoryElement> elements = new ArrayList<HistoryElement>();
                    elements.add(new HistoryElement(col - 1));
                    this.controller.removeColumn(elements);
                }
            }
            catch (NumberFormatException nf) {
                JOptionPane.showMessageDialog(null, "Not a number!");
            }
        }
    }

    public void addColumn() {
        String res = JOptionPane.showInputDialog(null, (Object)"At what column do you want to insert?");
        if (res != null) {
            try {
                int col = Integer.parseInt(res);
                if (col > 0 && col <= this.controller.getAlignmentLength()) {
                    ArrayList<HistoryElement> elements = new ArrayList<HistoryElement>();
                    elements.add(new HistoryElement(col - 1));
                    this.controller.addColumn(elements);
                }
            }
            catch (NumberFormatException nf) {
                JOptionPane.showMessageDialog(null, "Not a number!");
            }
        }
    }

    public void toggleSplit() {
        this.getSelectedProject().toggleSplit();
    }

    public void reload() throws Exception {
        this.saveSplitMode();
        this.closeAll();
        this.projectProperties.setFile(this.controller.getFileName());
        this.addView(this.controller.getFileName());
    }

    public void saveSplitMode() {
        AlignmentPanel ap = this.getSelectedProject();
        this.splitMode = this.isSplitMode();
        if (ap != null) {
            if (this.isSplitMode()) {
                this.divider = this.getSelectedProject().getSplitPane().getDividerLocation();
                this.p2 = ap.getTableView2().getViewport().getViewPosition();
                this.p3 = ap.getTableView3().getViewport().getViewPosition();
                this.splitAlign = ap.horizontalSplit();
            } else {
                this.p1 = ap.getTableView().getViewport().getViewPosition();
            }
        } else {
            this.p1 = new Point(0, 0);
        }
    }

    public void splitMode(boolean mode) {
        this.splitAlign = mode;
        ((AlignmentPanel)this.views.getSelectedComponent()).splitMode(mode);
    }

    public void selectionMode(boolean mode) {
        this.selectionMode = mode;
        ((AlignmentPanel)this.views.getSelectedComponent()).selectionMode(mode);
    }

    public void operationMode(int mode) {
        this.operationMode = mode;
        ((AlignmentPanel)this.views.getSelectedComponent()).operationMode(this.operationMode);
    }

    public void setHistory(FileHistory hist) {
        this.controller.setFileHistory(hist);
    }

    public AlignmentProperties getProperties() {
        return this.properties;
    }

    public void updateCellSize() {
        this.getSelectedProject().updateCellSize();
    }

    public void storeProperties() {
        try {
            File f = new File(AlignmentProperties.getProjectDir() + "/properties.obj");
            if (f.exists()) {
                f.delete();
            }
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
            oos.writeObject(this.properties);
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateGrid() {
        this.getSelectedProject().updateGrid();
    }

    public void setBackground() {
        Color c = JColorChooser.showDialog(this, "Choose Background Color", this.properties.getBackground());
        this.properties.setBackground(c);
    }

    public void setTextColor() {
        Color c = JColorChooser.showDialog(this, "Choose Text Color", this.properties.getBackground());
        this.properties.setTextColor(c);
    }

    public void setPrimarySelectionColor() {
        Color c = JColorChooser.showDialog(this, "Choose Color for Primary Selection", this.properties.getBackground());
        this.properties.setPrimarySelectionColor(c);
    }

    public void setSecondarySelectionColor() {
        Color c = JColorChooser.showDialog(this, "Choose Color for Secondary Selection", this.properties.getBackground());
        this.properties.setSecondarySelectionColor(c);
    }

    public void setSequenceColor() {
        Color c = JColorChooser.showDialog(this, "Choose Color for Sequence Names", this.properties.getBackground());
        this.properties.setSequenceColor(c);
    }

    public void setGColor() {
        Color c = JColorChooser.showDialog(this, "Choose Color for G", this.properties.getBackground());
        this.properties.setGColor(c);
    }

    public void setCColor() {
        Color c = JColorChooser.showDialog(this, "Choose Color for C", this.properties.getBackground());
        this.properties.setCColor(c);
    }

    public void setAColor() {
        Color c = JColorChooser.showDialog(this, "Choose Color for A", this.properties.getBackground());
        this.properties.setAColor(c);
    }

    public void setUColor() {
        Color c = JColorChooser.showDialog(this, "Choose Color for U", this.properties.getBackground());
        this.properties.setUColor(c);
    }

    public void addSequences() {
        JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
        fileChooser.addChoosableFileFilter(new ColFilter());
        fileChooser.addChoosableFileFilter(new TxtFilter());
        int chooserStatus = fileChooser.showOpenDialog(null);
        if (chooserStatus == 0) {
            File f = fileChooser.getSelectedFile();
            Alignment a = null;
            try {
                if (fileChooser.getFileFilter() instanceof ColFilter || f.getName().endsWith("col")) {
                    a = AlignmentIOController.loadAlignment(f, 0);
                } else if (fileChooser.getFileFilter() instanceof TxtFilter || f.getName().endsWith("txt") || f.getName().endsWith("widetext")) {
                    a = AlignmentIOController.loadAlignment(f, 1);
                }
                if (a != null) {
                    int added = this.controller.addSequences(a);
                    JOptionPane.showMessageDialog(null, added + " sequences imported");
                }
                this.validate();
                this.repaint();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void unpairBases() {
        int[] cols = this.getSelectedProject().getSelectedColumns();
        String[] names = this.getSelectedProject().getSelectedSequenceNames();
        ArrayList<HistoryElement> elements = new ArrayList<HistoryElement>();
        elements.add(new HistoryElement(names, cols));
        this.controller.unpair(elements);
    }

    public void pairBases() {
        int[] cols = this.getSelectedProject().getSelectedColumns();
        if (cols.length % 2 == 0) {
            String[] names = this.getSelectedProject().getSelectedSequenceNames();
            ArrayList<HistoryElement> elements = new ArrayList<HistoryElement>();
            elements.add(new HistoryElement(names, cols));
            this.controller.pair(elements);
        } else {
            JOptionPane.showMessageDialog(null, "You must select an equal number of columns");
        }
    }

    public void removeColors() {
        this.controller.removeColors();
        this.repaint();
    }

    public void removeSequences() {
        if (this.views.getSelectedComponent() != null) {
            String[] delSequences = this.getSelectedSequences();
            if (delSequences != null) {
                StringBuffer sb = new StringBuffer("Delete the following sequences? \n");
                for (int i = 0; i < delSequences.length; ++i) {
                    sb.append(delSequences[i]).append("\n");
                }
                if (JOptionPane.showConfirmDialog(this, sb.toString()) == 0) {
                    if (this.controller.deleteSequences(delSequences)) {
                        // empty if block
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "The sequences cannot be deleted");
                }
            } else {
                JOptionPane.showMessageDialog(this, "Select sequences to delete");
            }
        } else {
            JOptionPane.showMessageDialog(this, "You need to create or open a project before deleting");
        }
    }

    public void fitCases() {
        this.controller.fitCases();
        this.controller.getMainAlignment().updatePairings();
        this.validate();
        this.repaint();
    }

    public void emptyPairingmask() {
        this.controller.emptyPairingmask();
    }

    public AlignmentFrame parent() {
        return this.parent;
    }

    public JPanel getOverviewPanel(JFrame owner) {
        JPanel overviewPanel = new JPanel(new BorderLayout());
        this.overview = new AlignmentCanvas(owner, this.controller);
        JScrollPane jsp = new JScrollPane(this.overview);
        jsp.setVerticalScrollBarPolicy(20);
        jsp.setHorizontalScrollBarPolicy(30);
        JButton zoomIn = new JButton("+");
        zoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AlignmentContainer.this.overview.setZoom(AlignmentContainer.this.overview.getZoom() + 1);
            }
        });
        JButton fitZoom = new JButton("Fit");
        fitZoom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AlignmentContainer.this.overview.adjustZoom();
            }
        });
        JButton zoomOut = new JButton("-");
        zoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AlignmentContainer.this.overview.setZoom(AlignmentContainer.this.overview.getZoom() - 1);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(zoomOut);
        buttonPanel.add(fitZoom);
        buttonPanel.add(zoomIn);
        this.overview.addMouseListener(this);
        this.overview.adjustZoom();
        overviewPanel.add(jsp);
        overviewPanel.add((Component)buttonPanel, "South");
        return overviewPanel;
    }

    public void addPairingmask() {
        PairingMask mask = new PairingMask(this.controller.getAlignmentLength());
        this.controller.addPairingMask(mask);
    }
}

