/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.gui.alignment.table;

import dk.kvl.gui.alignment.AlignmentPanel;
import dk.kvl.gui.alignment.table.AlignmentBorder;
import dk.kvl.gui.alignment.table.AlignmentDataModel;
import dk.kvl.gui.properties.AlignmentProperties;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class AlignmentRenderer
extends DefaultTableCellRenderer {
    private AlignmentProperties properties = null;
    private AlignmentPanel ap;
    static int count;

    protected AlignmentRenderer() {
        this.setOpaque(true);
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(0);
        if (this.properties == null) {
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        } else {
            try {
                this.setBorder(new AlignmentBorder(this.properties));
            }
            catch (Exception e) {
                this.setBorder(new EmptyBorder(1, 1, 1, 1));
            }
        }
    }

    public AlignmentRenderer(AlignmentProperties properties, AlignmentPanel ap) {
        this();
        this.properties = properties;
        this.ap = ap;
    }

    public Component getTableCellRendererComponent(JTable table, Object title, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setForeground(this.properties.getTextColor());
        this.setFont(this.properties.getTableFont());
        this.setHorizontalTextPosition(0);
        String txt = (String)title;
        if (txt == null) {
            txt = "" + table.getModel().getValueAt(row, column);
        }
        this.setText(txt);
        if (this.properties.isBaseColoringEnabled()) {
            this.baseColoring(txt, row);
        }
        if (this.properties.isColored()) {
            this.analysisColoring(table, row, column);
        } else {
            this.setBackground(this.properties.getBackground());
        }
        if (isSelected) {
            if (this.ap.isSplit()) {
                Color primary = this.properties.getPrimarySelectionColor();
                Color secondary = this.properties.getSecondarySelectionColor();
                JTable table2 = this.ap.getTable2();
                JTable table3 = this.ap.getTable3();
                if (this.ap.getOperationMode() == 1) {
                    if (this.ap.getSelectionMode()) {
                        if (table2.equals(table)) {
                            this.setBackground(primary);
                        }
                    } else if (table2.equals(table)) {
                        this.setBackground(primary);
                    } else {
                        this.setBackground(secondary);
                    }
                } else if (this.ap.getOperationMode() == 2) {
                    if (this.ap.getSelectionMode()) {
                        if (table2.equals(table)) {
                            this.setBackground(primary);
                        }
                    } else if (table2.equals(table)) {
                        this.setBackground(secondary);
                    } else {
                        this.setBackground(primary);
                    }
                } else if (this.ap.getSelectionMode()) {
                    if (table2.equals(table)) {
                        this.setBackground(primary);
                    }
                } else {
                    this.setBackground(primary);
                }
            } else {
                this.setBackground(this.properties.getPrimarySelectionColor());
            }
        }
        return this;
    }

    public void baseColoring(String txt, int row) {
        if (this.ap.getController().getPairingmask() != null && row == 0) {
            this.setForeground(this.properties.getTextColor());
        } else if (txt.equals("a") || txt.equals("A")) {
            this.setForeground(this.properties.getAColor());
        } else if (txt.equals("g") || txt.equals("G")) {
            this.setForeground(this.properties.getGColor());
        } else if (txt.equals("c") || txt.equals("C")) {
            this.setForeground(this.properties.getCColor());
        } else if (txt.equals("u") || txt.equals("U") || txt.equals("t") || txt.equals("T")) {
            this.setForeground(this.properties.getUColor());
        } else if (txt.equals("-")) {
            this.setForeground(this.properties.getTextColor());
        } else {
            this.setForeground(this.properties.getTextColor());
        }
        this.setBackground(this.properties.getBackground());
    }

    protected void analysisColoring(JTable table, int row, int column) {
        AlignmentDataModel adm = (AlignmentDataModel)table.getModel();
        Color c = adm.getBackground(row, column);
        if (c.equals(Color.WHITE)) {
            this.setBackground(this.properties.getBackground());
        } else {
            this.setBackground(c);
        }
    }
}

