/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.gui.alignment.table;

import dk.kvl.controller.AlignmentController;
import dk.kvl.gui.alignment.table.SmallHeader;
import dk.kvl.gui.properties.AlignmentProperties;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class TitleTable
extends JTable {
    private AlignmentController controller;
    private String alignName;
    private Object[][] names = null;
    private AlignmentProperties properties;
    private int maximumWidth = -1;

    public TitleTable(AlignmentController controller, String alignName, AlignmentProperties prop) {
        this.controller = controller;
        this.alignName = alignName;
        this.setDragEnabled(true);
        this.properties = prop;
        Object[] title = new Object[]{""};
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setModel(new DefaultTableModel(this.getSequenceNames(), title));
        this.getTableHeader().setDefaultRenderer(new SmallHeader(controller.getMainAlignment(), prop));
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(false);
    }

    protected Object[][] getSequenceNames() {
        String[] sortedNames = this.controller.getSortedNames();
        if (this.controller.getPairingmaskName() != null) {
            this.names = new String[sortedNames.length + 1][1];
            this.names[0][0] = this.controller.getPairingmaskName();
            for (int i = 0; i < sortedNames.length; ++i) {
                this.names[i + 1][0] = sortedNames[i];
            }
        } else {
            this.names = new String[sortedNames.length][1];
            for (int i = 0; i < sortedNames.length; ++i) {
                this.names[i][0] = sortedNames[i];
            }
        }
        return this.names;
    }

    public String getSequenceName(int row) {
        return (String)this.names[row][0];
    }

    public Collection getSelectedNames() {
        int[] names = this.getSelectedRows();
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < names.length; ++i) {
            v.add(this.getSequenceName(names[i]));
        }
        return v;
    }

    public int getMaximumWidth() {
        Enumeration keys = this.controller.getSequenceKeys();
        FontMetrics fm = this.getAccessibleContext().getAccessibleComponent().getFontMetrics(this.properties.getTableFont());
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            if (this.maximumWidth >= fm.stringWidth(name)) continue;
            this.maximumWidth = fm.stringWidth(name);
        }
        return this.maximumWidth;
    }
}

