/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.gui.components;

import dk.kvl.alignmenttools.Alignment;
import dk.kvl.alignmenttools.Analyzer;
import dk.kvl.controller.ProgramController;
import dk.kvl.gui.alignment.AlignmentContainer;
import dk.kvl.gui.components.OkCancelPanel;
import dk.kvl.gui.components.ProgramPanel;
import dk.kvl.gui.properties.AlignmentProperties;
import dk.kvl.gui.properties.ProjectProperties;
import dk.kvl.tools.Program;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class AnalyzeFrame
extends JFrame
implements ActionListener {
    private final Alignment alignment;
    private ProgramController programs = null;
    private final AlignmentProperties properties;
    private ActionListener resultListener;
    private String projectName;
    private ProjectProperties pProperties;

    public AnalyzeFrame(AlignmentProperties props, ProjectProperties pProperties, Alignment align, ActionListener listener, String projectName) throws Exception {
        super("Programs");
        this.resultListener = listener;
        this.projectName = projectName;
        this.alignment = align;
        this.properties = props;
        this.pProperties = pProperties;
        this.programs = this.properties.getProgramController();
        this.programs.reset();
        ProgramPanel programPanel = new ProgramPanel(props, this.programs);
        this.getContentPane().add("Center", programPanel);
        this.getContentPane().add("South", new OkCancelPanel(this));
        this.setLocation(50, 50);
        this.setSize(700, 500);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("Cancel")) {
            ((AlignmentContainer)this.resultListener).setCursor(new Cursor(0));
            this.dispose();
        } else {
            Vector<Program> selectedPrograms = new Vector<Program>();
            Enumeration e = this.programs.getProgramKeys();
            while (e.hasMoreElements()) {
                Program p = this.programs.getProgram((String)e.nextElement());
                if (!p.isSelected()) continue;
                selectedPrograms.add(p);
            }
            if (selectedPrograms.size() > 0) {
                Analyzer analyzer = new Analyzer(selectedPrograms, this.alignment, this.properties, this.pProperties, this.resultListener, this.projectName, System.currentTimeMillis() + "");
            } else {
                JOptionPane.showMessageDialog(this, "No programs selected", "WARNING", 2);
                ((AlignmentContainer)this.resultListener).setCursor(new Cursor(0));
            }
            this.resultListener = null;
            this.dispose();
        }
    }

    public void removeActionListener() {
        this.resultListener = null;
    }
}

