/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.gui.properties;

import dk.kvl.gui.properties.AlignmentProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class ProjectProperties
extends Properties {
    private String header = "This file was created automatically, and should not be manually edited";

    public ProjectProperties(String name, String file, String path) {
        this.setName(name);
        this.setFile(file);
        this.setPath(path);
    }

    public ProjectProperties(String name, String file) {
        this.setName(name);
        this.setFile(file);
    }

    public ProjectProperties(String fileName) throws IOException {
        this.load(fileName);
    }

    public void setName(String name) {
        this.setProperty("name", name);
    }

    public void setFile(String file) {
        this.setProperty("file", file);
    }

    public void setPath(String path) {
        this.setProperty("path", path);
    }

    public void load(String name) throws IOException {
        this.load(new FileInputStream(AlignmentProperties.getProjectDir() + "/" + name));
    }

    public String getName() {
        return this.getProperty("name");
    }

    public String getFile() {
        return this.getProperty("file");
    }

    public String getPath() {
        return this.getProperty("path");
    }

    public void store() throws IOException, FileNotFoundException {
        File f = new File(AlignmentProperties.getProjectDir() + "/" + this.getName() + ".prj");
        FileOutputStream fos = new FileOutputStream(f);
        this.store(fos, this.header);
        fos.close();
    }
}

