/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.alignmenttools.io;

import dk.kvl.alignmenttools.Alignment;
import dk.kvl.alignmenttools.io.AlignmentReader;
import dk.kvl.sequencetools.PairingMask;
import dk.kvl.sequencetools.Sequence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;

public class FastaReader
extends BufferedReader
implements AlignmentReader {
    private Alignment alignment = new Alignment();

    public FastaReader(File inFile) throws FileNotFoundException {
        super(new FileReader(inFile));
        this.readFile();
    }

    public Alignment getAlignment() {
        if (this.alignment.getPairingMask() != null) {
            this.alignment.updatePairings();
        } else {
            this.alignment.toLowerCase();
        }
        this.alignment.emptyInfo();
        return this.alignment;
    }

    protected void readFile() {
        String line = null;
        String title = null;
        StringBuffer sequence = null;
        try {
            while ((line = this.readLine()) != null) {
                if (line.startsWith(">")) {
                    if (title != null) {
                        if (title.substring(0, 4).equalsIgnoreCase("pair")) {
                            this.alignment.addPairingMask(new PairingMask(title, sequence.toString(), 1, true));
                        } else {
                            this.alignment.addSequence(new Sequence(title, sequence.toString(), 1, true));
                        }
                    }
                    sequence = new StringBuffer();
                    title = line.substring(1, line.length());
                    continue;
                }
                sequence.append(line.trim());
            }
            if (title.substring(0, 4).equalsIgnoreCase("pair")) {
                this.alignment.addPairingMask(new PairingMask(title, sequence.toString(), 1, true));
            } else {
                this.alignment.addSequence(new Sequence(title, sequence.toString(), 1, true));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

