/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.gui.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FontChooser
extends JDialog {
    private Font oldFont = null;
    private JComboBox fontChooser = null;
    private JTextField size = null;
    private static Font newFont = null;

    public FontChooser(JFrame owner, Font oldFont) {
        super((Frame)owner, "Define your font");
        this.getContentPane().setLayout(new BorderLayout());
        this.oldFont = oldFont;
        newFont = oldFont;
        this.arrangeComponents();
        this.setLocation(350, 350);
        this.setSize(300, 200);
        this.setVisible(true);
    }

    protected void arrangeComponents() {
        JLabel header = new JLabel("Choose font, size and color");
        this.getContentPane().add("North", header);
        JPanel selectPanel = new JPanel(new GridLayout(2, 1));
        JLabel fontLabel = new JLabel("Font: ");
        JLabel sizeLabel = new JLabel("Size: ");
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.fontChooser = new JComboBox<String>(fonts);
        this.size = new JTextField("" + this.oldFont.getSize(), 2);
        JPanel p1 = new JPanel(new FlowLayout(0));
        JPanel p2 = new JPanel(new FlowLayout(0));
        p1.add(fontLabel);
        p1.add(this.fontChooser);
        p2.add(sizeLabel);
        p2.add(this.size);
        selectPanel.add(p1);
        selectPanel.add(p2);
        JPanel okCancelPanel = new JPanel();
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FontChooser.this.okButtonPressed();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FontChooser.this.cancelButtonPressed();
            }
        });
        okCancelPanel.add(okButton);
        okCancelPanel.add(cancelButton);
        this.getContentPane().add("South", okCancelPanel);
        this.getContentPane().add("Center", selectPanel);
    }

    public void okButtonPressed() {
        try {
            int textSize = Integer.parseInt(this.size.getText());
            newFont = new Font((String)this.fontChooser.getSelectedItem(), 0, textSize);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Illigal font definition, try again");
        }
    }

    public void cancelButtonPressed() {
        this.dispose();
    }

    public void colorButtonPressed() {
        Color color = JColorChooser.showDialog(this, "Choose color", Color.BLACK);
    }

    public static Font getNewFont() {
        return newFont;
    }
}

