/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.tools.history;

import dk.kvl.alignmenttools.Alignment;
import dk.kvl.tools.History;
import dk.kvl.tools.history.FileHistoryItem;

public class ColFileHistoryItem
implements FileHistoryItem {
    private History history;
    private String projectDir;
    private String name;
    private transient Alignment alignment;

    public ColFileHistoryItem(Alignment alignment, String projectDir, String name) {
        try {
            this.alignment = alignment;
            this.projectDir = projectDir;
            this.name = name;
            this.setHistory();
        }
        catch (Exception e) {
            System.out.println("Error reading history information: " + e);
            e.printStackTrace();
        }
    }

    public ColFileHistoryItem(String projectDir, String name) {
        this.projectDir = projectDir;
        this.name = name;
    }

    public void setHistory() {
        try {
            if (this.history == null) {
                this.history = new History(this.alignment);
            }
        }
        catch (Exception e) {
            System.out.println("Error loading history information: " + e);
            e.printStackTrace();
        }
    }

    public History getHistory() {
        return this.history;
    }

    public boolean equals(Object o) {
        ColFileHistoryItem item = (ColFileHistoryItem)o;
        return this.name.equals(item.getLabel());
    }

    public String getFilePath() {
        return this.projectDir;
    }

    public String getLabel() {
        return this.name;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }
}

