/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.tools.history;

import dk.kvl.alignmenttools.Alignment;
import dk.kvl.sequencetools.Sequence;
import dk.kvl.tools.history.HistoryItem;

public class DeleteSequences
implements HistoryItem {
    private Sequence[] deletedSequences;

    public DeleteSequences(Sequence[] deletedSequences) {
        this.deletedSequences = deletedSequences;
    }

    public void undo(Alignment alignment) {
        for (int i = 0; i < this.deletedSequences.length; ++i) {
            alignment.addSequence(this.deletedSequences[i]);
        }
        alignment.sort();
    }

    public void redo(Alignment alignment) {
        for (int i = 0; i < this.deletedSequences.length; ++i) {
            alignment.removeSequence(this.deletedSequences[i].getLabel());
        }
        alignment.sort();
    }

    public String getLabel() {
        return "Delete sequences";
    }
}

