/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.tools.history;

import dk.kvl.alignmenttools.Alignment;
import dk.kvl.sequencetools.Sequence;
import dk.kvl.tools.history.HistoryItem;
import java.util.Enumeration;

public class RemoveColumn
implements HistoryItem {
    private int index;
    private char[] removedSymbols;

    public RemoveColumn(int index, char[] removed) {
        this.index = index;
        this.removedSymbols = removed;
    }

    public void undo(Alignment alignment) {
        Enumeration e = alignment.getSequences();
        int i = 0;
        while (e.hasMoreElements()) {
            Sequence s = (Sequence)e.nextElement();
            s.addColumn(this.index, this.removedSymbols[i]);
            ++i;
        }
        if (alignment.getPairingMask() != null) {
            alignment.getPairingMask().addColumn(this.index, this.removedSymbols[this.removedSymbols.length - 1]);
        }
        alignment.updateLength();
    }

    public void redo(Alignment alignment) {
        alignment.removeColumn(this.index);
    }

    public String getLabel() {
        return "Remove column";
    }
}

