/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.alignmenttools.io;

import dk.kvl.alignmenttools.Alignment;
import dk.kvl.alignmenttools.io.AlignmentReader;
import dk.kvl.sequencetools.PairingMask;
import dk.kvl.sequencetools.Sequence;
import dk.kvl.tools.StringTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JOptionPane;

public class WideFileReader
extends BufferedReader
implements AlignmentReader {
    private int counter = 1;
    private Hashtable sequences = new Hashtable();
    private Hashtable pairingMasks = new Hashtable();
    private int alphabet = 1;
    private int number = 1;

    public WideFileReader(Reader aReader) throws IOException {
        super(aReader);
        this.readLines();
        this.close();
    }

    public static FileReader getFileReader(String fileName) throws FileNotFoundException {
        return new FileReader(new File(fileName));
    }

    public static FileReader getFileReader(File file) throws FileNotFoundException {
        return new FileReader(file);
    }

    protected void readLines() throws IOException {
        String line = null;
        while (this.ready()) {
            line = this.readLine();
            if (line.equals("")) continue;
            this.saveLine(line);
        }
    }

    protected void saveLine(String line) {
        String[] seq = line.trim().split("\\s+");
        if (seq.length < 2) {
            seq = StringTools.split(line, ' ');
        }
        Sequence aSequence = null;
        if (seq == null) {
            return;
        }
        if (seq[1] == null) {
            seq[1] = seq[0];
            seq[0] = "seq" + this.counter;
        }
        if (seq[0].startsWith("pair") || seq[0].startsWith("Pair")) {
            try {
                aSequence = new PairingMask(seq[0], seq[1], 2, true);
                this.pairingMasks.put(seq[0], aSequence);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                if (this.sequences.get(seq[0]) == null) {
                    aSequence = new Sequence(seq[0], seq[1], this.alphabet, true);
                    aSequence.setNumber(this.number);
                    ++this.number;
                    this.sequences.put(seq[0], aSequence);
                } else {
                    JOptionPane.showMessageDialog(null, "Adding sequence: " + seq[0] + " is cancelled.\n because a sequence with that name allready exsists.");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public Enumeration getKeys() {
        return this.sequences.keys();
    }

    public String getSequence(String key) {
        return (String)this.sequences.get(key);
    }

    public Hashtable getSequences() {
        return this.sequences;
    }

    public Hashtable getPairingMasks() {
        return this.pairingMasks;
    }

    public Alignment getAlignment() {
        Alignment alignment = new Alignment(this.sequences, this.pairingMasks);
        if (alignment.getPairingMask() != null) {
            alignment.updatePairings();
        } else {
            alignment.toLowerCase();
        }
        alignment.emptyInfo();
        return alignment;
    }
}

